/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.Result;
import mil.nga.geopackage.db.ResultUtils;

public class ResultSetResult
implements Result {
    protected ResultSet resultSet;

    public ResultSetResult(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Object getValue(int index) {
        return this.getValue(index, null);
    }

    public Object getValue(int index, GeoPackageDataType dataType) {
        Object value;
        try {
            value = this.resultSet.getObject(this.resultIndexToResultSetIndex(index));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get value for column index: " + index, (Throwable)e);
        }
        value = ResultUtils.getValue((Object)value, (GeoPackageDataType)dataType);
        return value;
    }

    public boolean moveToNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to move ResultSet cursor to next", (Throwable)e);
        }
    }

    public boolean moveToFirst() {
        return true;
    }

    public int getPosition() {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get ResultSet row", (Throwable)e);
        }
    }

    public boolean moveToPosition(int position) {
        try {
            for (int i = 0; i < position; ++i) {
                if (this.resultSet.next()) continue;
                return false;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to move ResultSet cursor to first", (Throwable)e);
        }
        return true;
    }

    public int getColumnCount() {
        int count = 0;
        try {
            count = this.resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get ResultSet column count", (Throwable)e);
        }
        return count;
    }

    public int getColumnIndex(String columnName) {
        int index;
        try {
            index = this.resultSetIndexToResultIndex(this.resultSet.findColumn(columnName));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to find column index for column name: " + columnName, (Throwable)e);
        }
        return index;
    }

    public int getType(int columnIndex) {
        int type;
        try {
            type = this.resultSet.getMetaData().getColumnType(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get column type for column index: " + columnIndex, (Throwable)e);
        }
        return type;
    }

    public String getString(int columnIndex) {
        String value;
        try {
            value = this.resultSet.getString(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get String value for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public int getInt(int columnIndex) {
        int value;
        try {
            value = this.resultSet.getInt(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get int value for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public byte[] getBlob(int columnIndex) {
        byte[] value;
        try {
            value = this.resultSet.getBytes(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get blob bytes for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public long getLong(int columnIndex) {
        long value;
        try {
            value = this.resultSet.getLong(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get long value for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public short getShort(int columnIndex) {
        short value;
        try {
            value = this.resultSet.getShort(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get short value for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public double getDouble(int columnIndex) {
        double value;
        try {
            value = this.resultSet.getDouble(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get double value for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public float getFloat(int columnIndex) {
        float value;
        try {
            value = this.resultSet.getFloat(this.resultIndexToResultSetIndex(columnIndex));
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get float value for column index: " + columnIndex, (Throwable)e);
        }
        return value;
    }

    public boolean wasNull() {
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to determine if previous value retrieved was null", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.resultSet.getStatement().close();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to close ResultSet Statement", (Throwable)e);
        }
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to close ResultSet", (Throwable)e);
        }
    }

    protected int resultIndexToResultSetIndex(int resultIndex) {
        return resultIndex + 1;
    }

    protected int resultSetIndexToResultIndex(int resultSetIndex) {
        return resultSetIndex - 1;
    }

    public static int resultSetTypeToSqlLite(int columnType) {
        int type;
        switch (columnType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                type = 1;
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 91: 
            case 93: 
            case 2005: {
                type = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                type = 2;
                break;
            }
            case -2: 
            case 2004: {
                type = 4;
                break;
            }
            case 0: {
                type = 0;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported ResultSet Metadata Column Type: " + columnType);
            }
        }
        return type;
    }
}

