/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.SQLUtils;

public class GeoPackageConnection
extends GeoPackageCoreConnection {
    private static final Logger log = Logger.getLogger(GeoPackageConnection.class.getName());
    private final File file;
    private final Connection connection;
    private Boolean autoCommit = null;

    public GeoPackageConnection(File file, Connection connection, ConnectionSource connectionSource) {
        super(connectionSource);
        this.file = file;
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void execSQL(String sql) {
        SQLUtils.execSQL(this.connection, sql);
    }

    public void beginTransaction() {
        if (this.autoCommit != null) {
            throw new GeoPackageException("Failed to begin transaction, previous transaction was not ended");
        }
        this.autoCommit = SQLUtils.beginTransaction(this.connection);
    }

    public void endTransaction(boolean successful) {
        SQLUtils.endTransaction(this.connection, successful, this.autoCommit);
        this.autoCommit = null;
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to commit connection", (Throwable)e);
        }
    }

    public boolean inTransaction() {
        return this.autoCommit != null;
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        return SQLUtils.delete(this.connection, table, whereClause, whereArgs);
    }

    public int count(String table, String where, String[] args) {
        return SQLUtils.count(this.connection, table, where, args);
    }

    public Integer min(String table, String column, String where, String[] args) {
        return SQLUtils.min(this.connection, table, column, where, args);
    }

    public Integer max(String table, String column, String where, String[] args) {
        return SQLUtils.max(this.connection, table, column, where, args);
    }

    public void close() {
        super.close();
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Failed to close GeoPackage connection to: " + this.file.getAbsolutePath(), e);
        }
    }

    public Object querySingleResult(String sql, String[] args, int column, GeoPackageDataType dataType) {
        return SQLUtils.querySingleResult(this.connection, sql, args, column, dataType);
    }

    public List<Object> querySingleColumnResults(String sql, String[] args, int column, GeoPackageDataType dataType, Integer limit) {
        return SQLUtils.querySingleColumnResults(this.connection, sql, args, column, dataType, limit);
    }

    public List<List<Object>> queryResults(String sql, String[] args, GeoPackageDataType[] dataTypes, Integer limit) {
        return SQLUtils.queryResults(this.connection, sql, args, dataTypes, limit);
    }

    public ResultSet query(String sql, String[] args) {
        return SQLUtils.query(this.connection, sql, args);
    }
}

