/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseMappedQuery<T, ID>
extends BaseMappedStatement<T, ID>
implements GenericRowMapper<T> {
    protected final FieldType[] resultsFieldTypes;
    private Map<String, Integer> columnPositions = null;
    private Object parent = null;
    private Object parentId = null;

    protected BaseMappedQuery(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultsFieldTypes) {
        super(tableInfo, statement, argFieldTypes);
        this.resultsFieldTypes = resultsFieldTypes;
    }

    @Override
    public T mapRow(DatabaseResults results) throws SQLException {
        Object id;
        Object cachedInstance;
        Map<String, Integer> colPosMap = this.columnPositions == null ? new HashMap<String, Integer>() : this.columnPositions;
        ObjectCache objectCache = results.getObjectCacheForRetrieve();
        if (objectCache != null && (cachedInstance = objectCache.get(this.clazz, id = this.idField.resultToJava(results, colPosMap))) != null) {
            return cachedInstance;
        }
        Object instance = this.tableInfo.createObject();
        Object id2 = null;
        boolean foreignCollections = false;
        for (FieldType fieldType : this.resultsFieldTypes) {
            if (fieldType.isForeignCollection()) {
                foreignCollections = true;
                continue;
            }
            Object val = fieldType.resultToJava(results, colPosMap);
            if (val != null && this.parent != null && fieldType.getField().getType() == this.parent.getClass() && val.equals(this.parentId)) {
                fieldType.assignField(instance, this.parent, true, objectCache);
            } else {
                fieldType.assignField(instance, val, false, objectCache);
            }
            if (!fieldType.isId()) continue;
            id2 = val;
        }
        if (foreignCollections) {
            for (FieldType fieldType : this.resultsFieldTypes) {
                BaseForeignCollection collection;
                if (!fieldType.isForeignCollection() || (collection = fieldType.buildForeignCollection(instance, id2)) == null) continue;
                fieldType.assignField(instance, collection, false, objectCache);
            }
        }
        if ((objectCache = results.getObjectCacheForStore()) != null && id2 != null) {
            objectCache.put(this.clazz, id2, instance);
        }
        if (this.columnPositions == null) {
            this.columnPositions = colPosMap;
        }
        return instance;
    }

    public void setParentInformation(Object parent, Object parentId) {
        this.parent = parent;
        this.parentId = parentId;
    }
}

