/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLog
implements Log {
    private final Logger logger;

    public JavaUtilLog(String className) {
        this.logger = Logger.getLogger(className);
    }

    @Override
    public boolean isLevelEnabled(Log.Level level) {
        return this.logger.isLoggable(this.levelToJavaLevel(level));
    }

    @Override
    public void log(Log.Level level, String msg) {
        this.logger.log(this.levelToJavaLevel(level), msg);
    }

    @Override
    public void log(Log.Level level, String msg, Throwable throwable) {
        this.logger.log(this.levelToJavaLevel(level), msg, throwable);
    }

    private Level levelToJavaLevel(Log.Level level) {
        switch (level) {
            case TRACE: {
                return Level.FINER;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case FATAL: {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }
}

