/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.sf.Geometry;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.geojson.Feature;
import mil.nga.sf.geojson.FeatureCollection;
import mil.nga.sf.geojson.GeoJsonObject;
import mil.nga.sf.geojson.GeometryCollection;
import mil.nga.sf.geojson.LineString;
import mil.nga.sf.geojson.MultiPoint;
import mil.nga.sf.geojson.MultiPolygon;
import mil.nga.sf.util.SFException;

public class FeatureConverter {
    private static final Logger LOGGER = Logger.getLogger(FeatureConverter.class.getName());
    public static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static Feature toFeature(String content) {
        return FeatureConverter.toTypedObject(Feature.class, content);
    }

    public static Feature toFeature(Object value) {
        return FeatureConverter.toTypedObject(Feature.class, value);
    }

    public static Feature toFeature(JsonNode tree) {
        return FeatureConverter.toTypedObject(Feature.class, tree);
    }

    public static Feature toFeature(Geometry simpleGeometry) {
        mil.nga.sf.geojson.Geometry geometry = FeatureConverter.toGeometry(simpleGeometry);
        Feature feature = new Feature(geometry);
        return feature;
    }

    public static FeatureCollection toFeatureCollection(String content) {
        return FeatureConverter.toTypedObject(FeatureCollection.class, content);
    }

    public static FeatureCollection toFeatureCollection(Object value) {
        return FeatureConverter.toTypedObject(FeatureCollection.class, value);
    }

    public static FeatureCollection toFeatureCollection(JsonNode tree) {
        return FeatureConverter.toTypedObject(FeatureCollection.class, tree);
    }

    public static FeatureCollection toFeatureCollection(Geometry simpleGeometry) {
        Feature feature = FeatureConverter.toFeature(simpleGeometry);
        FeatureCollection featureCollection = new FeatureCollection(feature);
        return featureCollection;
    }

    public static FeatureCollection toFeatureCollection(Collection<Geometry> simpleGeometries) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Geometry simpleGeometry : simpleGeometries) {
            Feature feature = FeatureConverter.toFeature(simpleGeometry);
            features.add(feature);
        }
        FeatureCollection featureCollection = new FeatureCollection(features);
        return featureCollection;
    }

    public static mil.nga.sf.geojson.Geometry toGeometry(String content) {
        return FeatureConverter.toTypedObject(mil.nga.sf.geojson.Geometry.class, content);
    }

    public static mil.nga.sf.geojson.Geometry toGeometry(Object value) {
        return FeatureConverter.toTypedObject(mil.nga.sf.geojson.Geometry.class, value);
    }

    public static mil.nga.sf.geojson.Geometry toGeometry(JsonNode tree) {
        return FeatureConverter.toTypedObject(mil.nga.sf.geojson.Geometry.class, tree);
    }

    public static mil.nga.sf.geojson.Geometry toGeometry(Geometry simpleGeometry) {
        mil.nga.sf.geojson.Geometry geometry = null;
        if (simpleGeometry != null) {
            if (simpleGeometry instanceof Point) {
                geometry = new mil.nga.sf.geojson.Point((Point)simpleGeometry);
            } else if (simpleGeometry instanceof mil.nga.sf.LineString) {
                geometry = new LineString((mil.nga.sf.LineString)simpleGeometry);
            } else if (simpleGeometry instanceof mil.nga.sf.MultiPoint) {
                geometry = new MultiPoint((mil.nga.sf.MultiPoint)simpleGeometry);
            } else if (simpleGeometry instanceof Polygon) {
                geometry = new mil.nga.sf.geojson.Polygon((Polygon)simpleGeometry);
            } else if (simpleGeometry instanceof MultiLineString) {
                geometry = new mil.nga.sf.geojson.MultiLineString((MultiLineString)simpleGeometry);
            } else if (simpleGeometry instanceof mil.nga.sf.MultiPolygon) {
                geometry = new MultiPolygon((mil.nga.sf.MultiPolygon)simpleGeometry);
            } else if (simpleGeometry instanceof mil.nga.sf.GeometryCollection) {
                mil.nga.sf.GeometryCollection simpleGeometryCollection = (mil.nga.sf.GeometryCollection)simpleGeometry;
                geometry = new GeometryCollection((mil.nga.sf.GeometryCollection<Geometry>)simpleGeometryCollection);
            } else {
                throw new SFException("Unsupported Geometry type: " + simpleGeometry.getClass().getSimpleName());
            }
        }
        return geometry;
    }

    public static GeoJsonObject toGeoJsonObject(String content) {
        return FeatureConverter.toTypedObject(GeoJsonObject.class, content);
    }

    public static GeoJsonObject toGeoJsonObject(Object value) {
        return FeatureConverter.toTypedObject(GeoJsonObject.class, value);
    }

    public static GeoJsonObject toGeoJsonObject(JsonNode tree) {
        return FeatureConverter.toTypedObject(GeoJsonObject.class, tree);
    }

    public static Map<String, Object> toMap(GeoJsonObject object) {
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        Map map = (Map)mapper.convertValue((Object)object, (TypeReference)typeRef);
        return map;
    }

    public static Map<String, Object> toMap(Geometry simpleGeometry) {
        mil.nga.sf.geojson.Geometry geometry = FeatureConverter.toGeometry(simpleGeometry);
        Map<String, Object> map = FeatureConverter.toMap(geometry);
        return map;
    }

    public static String toStringValue(Object object) {
        String stringValue = null;
        try {
            stringValue = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SFException("Failed to write object as a String: " + object, (Throwable)e);
        }
        return stringValue;
    }

    public static String toStringValue(Geometry simpleGeometry) {
        mil.nga.sf.geojson.Geometry geometry = FeatureConverter.toGeometry(simpleGeometry);
        String stringValue = FeatureConverter.toStringValue(geometry);
        return stringValue;
    }

    public static <T> T toTypedObject(Class<T> type, String content) {
        JsonNode tree;
        try {
            tree = mapper.readTree(content);
        }
        catch (Exception e) {
            throw new SFException("Failed to convert content to a node tree: " + content, (Throwable)e);
        }
        T typedObject = FeatureConverter.toTypedObject(type, tree);
        return typedObject;
    }

    public static <T> T toTypedObject(Class<T> type, Object value) {
        JsonNode tree = mapper.valueToTree(value);
        T typedObject = FeatureConverter.toTypedObject(type, tree);
        return typedObject;
    }

    public static <T> T toTypedObject(Class<T> type, JsonNode tree) {
        return FeatureConverter.toTypedObject(type, tree, true);
    }

    private static <T> T toTypedObject(Class<T> type, JsonNode tree, boolean topLevel) {
        Object object;
        try {
            object = mapper.treeToValue((TreeNode)tree, type);
        }
        catch (MismatchedInputException e) {
            String originalTree = tree.toString();
            object = FeatureConverter.toTypedObject(type, tree, originalTree, e);
            if (topLevel) {
                LOGGER.log(Level.WARNING, "Failed to convert node tree to a " + type.getSimpleName() + " object without modifications: " + originalTree, e);
                LOGGER.log(Level.INFO, "Modified node tree was successfully converted to a " + type.getSimpleName() + " object: " + tree);
            }
        }
        catch (JsonProcessingException e) {
            throw new SFException("Failed to convert node tree to a " + type.getSimpleName() + " object: " + tree, (Throwable)e);
        }
        return (T)object;
    }

    private static <T> T toTypedObject(Class<T> type, JsonNode tree, String originalTree, MismatchedInputException mismatchedInputException) {
        T object;
        List path = mismatchedInputException.getPath();
        if (path != null && !path.isEmpty()) {
            try {
                ObjectNode subNode = (ObjectNode)tree;
                for (int i = 0; i < path.size(); ++i) {
                    String fieldName = ((JsonMappingException.Reference)path.get(i)).getFieldName();
                    if (i + 1 < path.size()) {
                        subNode = (ObjectNode)tree.get(fieldName);
                        continue;
                    }
                    subNode.remove(fieldName);
                }
                object = FeatureConverter.toTypedObject(type, tree, false);
            }
            catch (Exception e) {
                throw new SFException("Failed to convert node tree to a " + type.getSimpleName() + " object: " + originalTree, (Throwable)mismatchedInputException);
            }
        } else {
            throw new SFException("Failed to convert node tree to a " + type.getSimpleName() + " object: " + originalTree, (Throwable)mismatchedInputException);
        }
        return object;
    }
}

