/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.table.ColumnConstraints;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.db.table.TableConstraints;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public abstract class UserTableReader<TColumn extends UserColumn, TTable extends UserTable<TColumn>> {
    private final String tableName;

    protected UserTableReader(String tableName) {
        this.tableName = tableName;
    }

    protected abstract TTable createTable(String var1, List<TColumn> var2);

    protected abstract TColumn createColumn(TableColumn var1);

    public TTable readTable(GeoPackageCoreConnection db) {
        ArrayList<TColumn> columnList = new ArrayList<TColumn>();
        TableInfo tableInfo = TableInfo.info(db, this.tableName);
        if (tableInfo == null) {
            throw new GeoPackageException("Table does not exist: " + this.tableName);
        }
        TableConstraints constraints = SQLiteMaster.queryForConstraints(db, this.tableName);
        for (TableColumn tableColumn : tableInfo.getColumns()) {
            if (tableColumn.getDataType() == null) {
                throw new GeoPackageException("Unsupported column data type " + tableColumn.getType());
            }
            TColumn column = this.createColumn(tableColumn);
            ColumnConstraints columnConstraints = constraints.getColumnConstraints(((UserColumn)column).getName());
            if (columnConstraints != null && columnConstraints.hasConstraints()) {
                ((UserColumn)column).clearConstraints();
                ((UserColumn)column).addConstraints(columnConstraints);
            }
            columnList.add(column);
        }
        TTable table = this.createTable(this.tableName, columnList);
        ((UserTable)table).addConstraints(constraints.getTableConstraints());
        return table;
    }
}

