/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.db.table.UniqueConstraint;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileColumns;
import mil.nga.geopackage.user.UserTable;

public class TileTable
extends UserTable<TileColumn> {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_ZOOM_LEVEL = "zoom_level";
    public static final String COLUMN_TILE_COLUMN = "tile_column";
    public static final String COLUMN_TILE_ROW = "tile_row";
    public static final String COLUMN_TILE_DATA = "tile_data";

    public TileTable(String tableName, List<TileColumn> columns) {
        super(new TileColumns(tableName, columns));
        UniqueConstraint uniqueConstraint = new UniqueConstraint();
        uniqueConstraint.add(this.getUserColumns().getZoomLevelColumn());
        uniqueConstraint.add(this.getUserColumns().getTileColumnColumn());
        uniqueConstraint.add(this.getUserColumns().getTileRowColumn());
        this.addConstraint(uniqueConstraint);
    }

    public TileTable(TileTable tileTable) {
        super(tileTable);
    }

    public TileTable copy() {
        return new TileTable(this);
    }

    @Override
    public String getDataType() {
        return ContentsDataType.TILES.getName();
    }

    public TileColumns getUserColumns() {
        return (TileColumns)super.getUserColumns();
    }

    public TileColumns createUserColumns(List<TileColumn> columns) {
        return new TileColumns(this.getTableName(), columns, true);
    }

    public int getZoomLevelColumnIndex() {
        return this.getUserColumns().getZoomLevelIndex();
    }

    public TileColumn getZoomLevelColumn() {
        return this.getUserColumns().getZoomLevelColumn();
    }

    public int getTileColumnColumnIndex() {
        return this.getUserColumns().getTileColumnIndex();
    }

    public TileColumn getTileColumnColumn() {
        return this.getUserColumns().getTileColumnColumn();
    }

    public int getTileRowColumnIndex() {
        return this.getUserColumns().getTileRowIndex();
    }

    public TileColumn getTileRowColumn() {
        return this.getUserColumns().getTileRowColumn();
    }

    public int getTileDataColumnIndex() {
        return this.getUserColumns().getTileDataIndex();
    }

    public TileColumn getTileDataColumn() {
        return this.getUserColumns().getTileDataColumn();
    }

    public static List<TileColumn> createRequiredColumns() {
        ArrayList<TileColumn> columns = new ArrayList<TileColumn>();
        columns.add(TileColumn.createIdColumn());
        columns.add(TileColumn.createZoomLevelColumn());
        columns.add(TileColumn.createTileColumnColumn());
        columns.add(TileColumn.createTileRowColumn());
        columns.add(TileColumn.createTileDataColumn());
        return columns;
    }

    public static List<TileColumn> createRequiredColumns(int startingIndex) {
        ArrayList<TileColumn> columns = new ArrayList<TileColumn>();
        columns.add(TileColumn.createIdColumn(startingIndex++));
        columns.add(TileColumn.createZoomLevelColumn(startingIndex++));
        columns.add(TileColumn.createTileColumnColumn(startingIndex++));
        columns.add(TileColumn.createTileRowColumn(startingIndex++));
        columns.add(TileColumn.createTileDataColumn(startingIndex++));
        return columns;
    }

    @Override
    protected void validateContents(Contents contents) {
        ContentsDataType dataType = contents.getDataType();
        if (dataType == null || dataType != ContentsDataType.TILES && dataType != ContentsDataType.GRIDDED_COVERAGE) {
            throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + TileTable.class.getSimpleName() + " must have a data type of " + ContentsDataType.TILES.getName() + " or " + ContentsDataType.GRIDDED_COVERAGE.getName());
        }
    }
}

