/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.sf.GeometryType;

public class FeatureColumn
extends UserColumn {
    private final GeometryType geometryType;

    public static FeatureColumn createPrimaryKeyColumn(String name) {
        return FeatureColumn.createPrimaryKeyColumn(-1, name);
    }

    public static FeatureColumn createPrimaryKeyColumn(int index, String name) {
        return new FeatureColumn(index, name, GeoPackageDataType.INTEGER, null, true, null, true, null);
    }

    public static FeatureColumn createGeometryColumn(String name, GeometryType type) {
        return FeatureColumn.createGeometryColumn(-1, name, type);
    }

    public static FeatureColumn createGeometryColumn(int index, String name, GeometryType type) {
        return FeatureColumn.createGeometryColumn(index, name, type, false, null);
    }

    public static FeatureColumn createGeometryColumn(String name, GeometryType type, boolean notNull, Object defaultValue) {
        return FeatureColumn.createGeometryColumn(-1, name, type, false, null);
    }

    public static FeatureColumn createGeometryColumn(int index, String name, GeometryType type, boolean notNull, Object defaultValue) {
        if (type == null) {
            throw new GeoPackageException("Geometry Type is required to create geometry column: " + name);
        }
        return new FeatureColumn(index, name, GeoPackageDataType.BLOB, null, notNull, defaultValue, false, type);
    }

    public static FeatureColumn createColumn(String name, GeoPackageDataType type) {
        return FeatureColumn.createColumn(-1, name, type);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type) {
        return FeatureColumn.createColumn(index, name, type, false, null);
    }

    public static FeatureColumn createColumn(String name, GeoPackageDataType type, boolean notNull) {
        return FeatureColumn.createColumn(-1, name, type, notNull);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type, boolean notNull) {
        return FeatureColumn.createColumn(index, name, type, notNull, null);
    }

    public static FeatureColumn createColumn(String name, GeoPackageDataType type, boolean notNull, Object defaultValue) {
        return FeatureColumn.createColumn(-1, name, type, notNull, defaultValue);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type, boolean notNull, Object defaultValue) {
        return FeatureColumn.createColumn(index, name, type, null, notNull, defaultValue);
    }

    public static FeatureColumn createColumn(String name, GeoPackageDataType type, Long max) {
        return FeatureColumn.createColumn(-1, name, type, max);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type, Long max) {
        return FeatureColumn.createColumn(index, name, type, max, false, null);
    }

    public static FeatureColumn createColumn(String name, GeoPackageDataType type, Long max, boolean notNull, Object defaultValue) {
        return FeatureColumn.createColumn(-1, name, type, max, notNull, defaultValue);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type, Long max, boolean notNull, Object defaultValue) {
        return new FeatureColumn(index, name, type, max, notNull, defaultValue, false, null);
    }

    public static FeatureColumn createColumn(TableColumn tableColumn) {
        return new FeatureColumn(tableColumn);
    }

    private FeatureColumn(int index, String name, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey, GeometryType geometryType) {
        super(index, name, FeatureColumn.getTypeName(name, dataType, geometryType), dataType, max, notNull, defaultValue, primaryKey);
        this.geometryType = geometryType;
    }

    private FeatureColumn(TableColumn tableColumn) {
        super(tableColumn);
        this.geometryType = FeatureColumn.getGeometryType(tableColumn);
    }

    protected static String getTypeName(String name, GeoPackageDataType dataType, GeometryType geometryType) {
        String type = geometryType != null ? geometryType.name() : FeatureColumn.getTypeName(name, dataType);
        return type;
    }

    private static GeometryType getGeometryType(TableColumn tableColumn) {
        GeometryType geometryType = null;
        if (tableColumn.isDataType(GeoPackageDataType.BLOB)) {
            geometryType = GeometryType.findName((String)tableColumn.getType());
        }
        return geometryType;
    }

    public FeatureColumn(FeatureColumn featureColumn) {
        super(featureColumn);
        this.geometryType = featureColumn.geometryType;
    }

    @Override
    public FeatureColumn copy() {
        return new FeatureColumn(this);
    }

    public boolean isGeometry() {
        return this.geometryType != null;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }
}

