/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.style;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.contents.ContentsIdExtension;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.extension.related.UserMappingTable;
import mil.nga.geopackage.extension.related.media.MediaTable;
import mil.nga.geopackage.extension.style.IconTable;
import mil.nga.geopackage.extension.style.StyleMappingTable;
import mil.nga.geopackage.extension.style.StyleTable;
import mil.nga.geopackage.property.GeoPackageProperties;

public abstract class FeatureCoreStyleExtension
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "feature_style";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "feature_style");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "feature_style");
    public static final String TABLE_MAPPING_STYLE = "nga_style_";
    public static final String TABLE_MAPPING_TABLE_STYLE = "nga_style_default_";
    public static final String TABLE_MAPPING_ICON = "nga_icon_";
    public static final String TABLE_MAPPING_TABLE_ICON = "nga_icon_default_";
    protected final RelatedTablesCoreExtension relatedTables;
    protected final ContentsIdExtension contentsId;

    protected FeatureCoreStyleExtension(GeoPackageCore geoPackage, RelatedTablesCoreExtension relatedTables) {
        super(geoPackage);
        this.relatedTables = relatedTables;
        this.contentsId = new ContentsIdExtension(geoPackage);
    }

    private Extensions getOrCreate(String featureTable) {
        Extensions extension = this.getOrCreate(EXTENSION_NAME, featureTable, null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public List<String> getTables() {
        ArrayList<String> tables = new ArrayList<String>();
        List<Extensions> extensions = this.getExtensions(EXTENSION_NAME);
        if (extensions != null) {
            for (Extensions extension : extensions) {
                tables.add(extension.getTableName());
            }
        }
        return tables;
    }

    public boolean has() {
        return super.has(EXTENSION_NAME);
    }

    @Override
    public boolean has(String featureTable) {
        return this.has(EXTENSION_NAME, featureTable, null);
    }

    public RelatedTablesCoreExtension getRelatedTables() {
        return this.relatedTables;
    }

    public ContentsIdExtension getContentsId() {
        return this.contentsId;
    }

    public void createRelationships(String featureTable) {
        this.createStyleRelationship(featureTable);
        this.createTableStyleRelationship(featureTable);
        this.createIconRelationship(featureTable);
        this.createTableIconRelationship(featureTable);
    }

    public boolean hasRelationship(String featureTable) {
        return this.hasStyleRelationship(featureTable) || this.hasTableStyleRelationship(featureTable) || this.hasIconRelationship(featureTable) || this.hasTableIconRelationship(featureTable);
    }

    public void createStyleRelationship(String featureTable) {
        this.createStyleRelationship(this.getMappingTableName(TABLE_MAPPING_STYLE, featureTable), featureTable, featureTable, "nga_style");
    }

    public boolean hasStyleRelationship(String featureTable) {
        return this.hasStyleRelationship(this.getMappingTableName(TABLE_MAPPING_STYLE, featureTable), featureTable, "nga_style");
    }

    public void createTableStyleRelationship(String featureTable) {
        this.createStyleRelationship(this.getMappingTableName(TABLE_MAPPING_TABLE_STYLE, featureTable), featureTable, "nga_contents_id", "nga_style");
    }

    public boolean hasTableStyleRelationship(String featureTable) {
        return this.hasStyleRelationship(this.getMappingTableName(TABLE_MAPPING_TABLE_STYLE, featureTable), "nga_contents_id", "nga_style");
    }

    public void createIconRelationship(String featureTable) {
        this.createStyleRelationship(this.getMappingTableName(TABLE_MAPPING_ICON, featureTable), featureTable, featureTable, "nga_icon");
    }

    public boolean hasIconRelationship(String featureTable) {
        return this.hasStyleRelationship(this.getMappingTableName(TABLE_MAPPING_ICON, featureTable), featureTable, "nga_icon");
    }

    public void createTableIconRelationship(String featureTable) {
        this.createStyleRelationship(this.getMappingTableName(TABLE_MAPPING_TABLE_ICON, featureTable), featureTable, "nga_contents_id", "nga_icon");
    }

    public boolean hasTableIconRelationship(String featureTable) {
        return this.hasStyleRelationship(this.getMappingTableName(TABLE_MAPPING_TABLE_ICON, featureTable), "nga_contents_id", "nga_icon");
    }

    public String getMappingTableName(String tablePrefix, String featureTable) {
        return tablePrefix + featureTable;
    }

    private boolean hasStyleRelationship(String mappingTableName, String baseTable, String relatedTable) {
        boolean has = false;
        try {
            has = this.relatedTables.hasRelations(baseTable, relatedTable, mappingTableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if Feature Style Relationship exists. Base Table: " + baseTable + ", Related Table: " + relatedTable + ", Mapping Table: " + mappingTableName, e);
        }
        return has;
    }

    private void createStyleRelationship(String mappingTableName, String featureTable, String baseTable, String relatedTable) {
        if (!this.hasStyleRelationship(mappingTableName, baseTable, relatedTable)) {
            this.getOrCreate(featureTable);
            if (baseTable.equals("nga_contents_id") && !this.contentsId.has()) {
                this.contentsId.getOrCreateExtension();
            }
            StyleMappingTable mappingTable = new StyleMappingTable(mappingTableName);
            if (relatedTable.equals("nga_style")) {
                this.relatedTables.addAttributesRelationship(baseTable, (AttributesTable)new StyleTable(), (UserMappingTable)mappingTable);
            } else {
                this.relatedTables.addMediaRelationship(baseTable, (MediaTable)new IconTable(), mappingTable);
            }
        }
    }

    public void deleteRelationships() {
        List<String> tables = this.getTables();
        for (String table : tables) {
            this.deleteRelationships(table);
        }
    }

    public void deleteRelationships(String featureTable) {
        this.deleteStyleRelationship(featureTable);
        this.deleteTableStyleRelationship(featureTable);
        this.deleteIconRelationship(featureTable);
        this.deleteTableIconRelationship(featureTable);
    }

    public void deleteStyleRelationship(String featureTable) {
        this.deleteStyleRelationship(this.getMappingTableName(TABLE_MAPPING_STYLE, featureTable), featureTable);
    }

    public void deleteTableStyleRelationship(String featureTable) {
        this.deleteStyleRelationship(this.getMappingTableName(TABLE_MAPPING_TABLE_STYLE, featureTable), featureTable);
    }

    public void deleteIconRelationship(String featureTable) {
        this.deleteStyleRelationship(this.getMappingTableName(TABLE_MAPPING_ICON, featureTable), featureTable);
    }

    public void deleteTableIconRelationship(String featureTable) {
        this.deleteStyleRelationship(this.getMappingTableName(TABLE_MAPPING_TABLE_ICON, featureTable), featureTable);
    }

    private void deleteStyleRelationship(String mappingTableName, String featureTable) {
        this.relatedTables.removeRelationshipsWithMappingTable(mappingTableName);
        if (!this.hasRelationship(featureTable)) {
            try {
                if (this.extensionsDao.isTableExists()) {
                    this.extensionsDao.deleteByExtension(EXTENSION_NAME, featureTable);
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to delete Feature Style extension. GeoPackage: " + this.geoPackage.getName() + ", Feature Table: " + featureTable, e);
            }
        }
    }

    public void removeExtension() {
        this.deleteRelationships();
        this.geoPackage.deleteTable("nga_style");
        this.geoPackage.deleteTable("nga_icon");
        try {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Style extension. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }
}

