/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.index;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.TableIndex;

public class TableIndexDao
extends BaseDaoImpl<TableIndex, String> {
    private GeometryIndexDao geometryIndexDao;

    public TableIndexDao(ConnectionSource connectionSource, Class<TableIndex> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public int deleteCascade(TableIndex tableIndex) throws SQLException {
        int count = 0;
        if (tableIndex != null) {
            GeometryIndexDao geometryIndexDao = this.getGeometryIndexDao();
            if (geometryIndexDao.isTableExists()) {
                DeleteBuilder db = geometryIndexDao.deleteBuilder();
                db.where().eq("table_name", (Object)tableIndex.getTableName());
                PreparedDelete deleteQuery = db.prepare();
                geometryIndexDao.delete(deleteQuery);
            }
            count = this.delete(tableIndex);
        }
        return count;
    }

    public int deleteCascade(Collection<TableIndex> tableIndexCollection) throws SQLException {
        int count = 0;
        if (tableIndexCollection != null) {
            for (TableIndex tableIndex : tableIndexCollection) {
                count += this.deleteCascade(tableIndex);
            }
        }
        return count;
    }

    public int deleteCascade(PreparedQuery<TableIndex> preparedDelete) throws SQLException {
        int count = 0;
        if (preparedDelete != null) {
            List tableIndexList = this.query(preparedDelete);
            count = this.deleteCascade(tableIndexList);
        }
        return count;
    }

    public int deleteByIdCascade(String id) throws SQLException {
        TableIndex tableIndex;
        int count = 0;
        if (id != null && (tableIndex = (TableIndex)this.queryForId(id)) != null) {
            count = this.deleteCascade(tableIndex);
        }
        return count;
    }

    public int deleteIdsCascade(Collection<String> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (String id : idCollection) {
                count += this.deleteByIdCascade(id);
            }
        }
        return count;
    }

    public void deleteTable(String table) {
        try {
            this.deleteByIdCascade(table);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete table: " + table, e);
        }
    }

    private GeometryIndexDao getGeometryIndexDao() throws SQLException {
        if (this.geometryIndexDao == null) {
            this.geometryIndexDao = (GeometryIndexDao)DaoManager.createDao((ConnectionSource)this.connectionSource, GeometryIndex.class);
        }
        return this.geometryIndexDao;
    }

    public int deleteAllCascade() throws SQLException {
        this.getGeometryIndexDao().deleteAll();
        int count = this.deleteAll();
        return count;
    }

    public int deleteAll() throws SQLException {
        int count = 0;
        if (this.isTableExists()) {
            DeleteBuilder db = this.deleteBuilder();
            PreparedDelete deleteQuery = db.prepare();
            count = this.delete(deleteQuery);
        }
        return count;
    }
}

