/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum ConstraintType {
    PRIMARY_KEY,
    UNIQUE,
    CHECK,
    FOREIGN_KEY,
    NOT_NULL,
    DEFAULT,
    COLLATE;

    public static final Set<ConstraintType> TABLE_CONSTRAINTS;
    public static final Set<ConstraintType> COLUMN_CONSTRAINTS;
    private static final Map<String, ConstraintType> tableLookup;
    private static final Map<String, ConstraintType> columnLookup;

    private static void addLookups(Map<String, ConstraintType> lookup, ConstraintType type) {
        String name = type.name();
        String[] parts = name.split("_");
        lookup.put(parts[0], type);
        if (parts.length > 0) {
            lookup.put(name.replaceAll("_", " "), type);
        }
    }

    public static ConstraintType getTableType(String value) {
        return tableLookup.get(value.toUpperCase());
    }

    public static ConstraintType getColumnType(String value) {
        return columnLookup.get(value.toUpperCase());
    }

    public static ConstraintType getType(String value) {
        ConstraintType type = ConstraintType.getTableType(value);
        if (type == null) {
            type = ConstraintType.getColumnType(value);
        }
        return type;
    }

    static {
        TABLE_CONSTRAINTS = new LinkedHashSet<ConstraintType>();
        TABLE_CONSTRAINTS.add(PRIMARY_KEY);
        TABLE_CONSTRAINTS.add(UNIQUE);
        TABLE_CONSTRAINTS.add(CHECK);
        TABLE_CONSTRAINTS.add(FOREIGN_KEY);
        COLUMN_CONSTRAINTS = new HashSet<ConstraintType>();
        COLUMN_CONSTRAINTS.add(PRIMARY_KEY);
        COLUMN_CONSTRAINTS.add(NOT_NULL);
        COLUMN_CONSTRAINTS.add(UNIQUE);
        COLUMN_CONSTRAINTS.add(CHECK);
        COLUMN_CONSTRAINTS.add(DEFAULT);
        COLUMN_CONSTRAINTS.add(COLLATE);
        COLUMN_CONSTRAINTS.add(FOREIGN_KEY);
        tableLookup = new HashMap<String, ConstraintType>();
        for (ConstraintType type : TABLE_CONSTRAINTS) {
            ConstraintType.addLookups(tableLookup, type);
        }
        columnLookup = new HashMap<String, ConstraintType>();
        for (ConstraintType type : COLUMN_CONSTRAINTS) {
            ConstraintType.addLookups(columnLookup, type);
        }
    }
}

