/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.MappedColumn;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public class TableMapping {
    private String fromTable;
    private String toTable;
    private boolean transferContent = true;
    private final Map<String, MappedColumn> columns = new LinkedHashMap<String, MappedColumn>();
    private final Set<String> droppedColumns = new HashSet<String>();
    private String where;

    public TableMapping() {
    }

    public TableMapping(String tableName, List<? extends UserColumn> columns) {
        this.fromTable = tableName;
        this.toTable = tableName;
        for (UserColumn userColumn : columns) {
            this.addColumn(new MappedColumn(userColumn));
        }
    }

    public TableMapping(UserTable<? extends UserColumn> table) {
        this(table.getTableName(), table.getColumns());
    }

    public TableMapping(UserTable<? extends UserColumn> table, Collection<String> droppedColumnNames) {
        this(table);
        for (String droppedColumnName : droppedColumnNames) {
            this.addDroppedColumn(droppedColumnName);
        }
    }

    public TableMapping(UserTable<? extends UserColumn> table, String newTableName) {
        this(table);
        this.toTable = newTableName;
    }

    public TableMapping(TableInfo tableInfo) {
        this.fromTable = tableInfo.getTableName();
        this.toTable = tableInfo.getTableName();
        for (TableColumn column : tableInfo.getColumns()) {
            this.addColumn(new MappedColumn(column));
        }
    }

    public TableMapping(GeoPackageCoreConnection db, String tableName) {
        this(TableInfo.info(db, tableName));
    }

    public String getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(String fromTable) {
        this.fromTable = fromTable;
    }

    public String getToTable() {
        return this.toTable;
    }

    public void setToTable(String toTable) {
        this.toTable = toTable;
    }

    public boolean isNewTable() {
        return this.toTable != null && !this.toTable.equals(this.fromTable);
    }

    public boolean isTransferContent() {
        return this.transferContent;
    }

    public void setTransferContent(boolean transferContent) {
        this.transferContent = transferContent;
    }

    public void addColumn(MappedColumn column) {
        this.columns.put(column.getToColumn(), column);
    }

    public void addColumn(String columnName) {
        this.columns.put(columnName, new MappedColumn(columnName));
    }

    public MappedColumn removeColumn(String columnName) {
        return this.columns.remove(columnName);
    }

    public Set<String> getColumnNames() {
        return this.columns.keySet();
    }

    public Set<Map.Entry<String, MappedColumn>> getColumns() {
        return this.columns.entrySet();
    }

    public Collection<MappedColumn> getMappedColumns() {
        return this.columns.values();
    }

    public MappedColumn getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public void addDroppedColumn(String columnName) {
        this.droppedColumns.add(columnName);
    }

    public boolean removeDroppedColumn(String columnName) {
        return this.droppedColumns.remove(columnName);
    }

    public Set<String> getDroppedColumns() {
        return this.droppedColumns;
    }

    public boolean isDroppedColumn(String columnName) {
        return this.droppedColumns.contains(columnName);
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }
}

