/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.io.ResourceIOUtils;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public class GeoPackageTableCreator {
    private final GeoPackageCoreConnection db;
    public static final String SPATIAL_REFERENCE_SYSTEM = GeoPackageTableCreator.getScript("spatial_reference_system");
    public static final String CONTENTS = GeoPackageTableCreator.getScript("contents");
    public static final String GEOMETRY_COLUMNS = GeoPackageTableCreator.getScript("geometry_columns");
    public static final String TILE_MATRIX_SET = GeoPackageTableCreator.getScript("tile_matrix_set");
    public static final String TILE_MATRIX = GeoPackageTableCreator.getScript("tile_matrix");
    public static final String DATA_COLUMNS = GeoPackageTableCreator.getScript("data_columns");
    public static final String DATA_COLUMN_CONSTRAINTS = GeoPackageTableCreator.getScript("data_column_constraints");
    public static final String METADATA = GeoPackageTableCreator.getScript("metadata");
    public static final String METADATA_REFERENCE = GeoPackageTableCreator.getScript("metadata_reference");
    public static final String EXTENSIONS = GeoPackageTableCreator.getScript("extensions");
    public static final String GRIDDED_COVERAGE = GeoPackageTableCreator.getScript("2d_gridded_coverage");
    public static final String GRIDDED_TILE = GeoPackageTableCreator.getScript("2d_gridded_tile");
    public static final String EXTENDED_RELATIONS = GeoPackageTableCreator.getScript("extended_relations");
    public static final String TABLE_INDEX = GeoPackageTableCreator.getScript("table_index");
    public static final String GEOMETRY_INDEX = GeoPackageTableCreator.getScript("geometry_index");
    public static final String INDEX_GEOMETRY_INDEX = GeoPackageProperties.getProperty("sql.geometry_index", "index");
    public static final String UNINDEX_GEOMETRY_INDEX = GeoPackageProperties.getProperty("sql.geometry_index", "unindex");
    public static final String FEATURE_TILE_LINK = GeoPackageTableCreator.getScript("feature_tile_link");
    public static final String TILE_SCALING = GeoPackageTableCreator.getScript("tile_scaling");
    public static final String CONTENTS_ID = GeoPackageTableCreator.getScript("contents_id");

    public GeoPackageTableCreator(GeoPackageCoreConnection db) {
        this.db = db;
    }

    public static final String getScript(String property) {
        return GeoPackageProperties.getProperty("sql", property);
    }

    public int createSpatialReferenceSystem() {
        return this.execSQLScript(SPATIAL_REFERENCE_SYSTEM);
    }

    public int createContents() {
        return this.execSQLScript(CONTENTS);
    }

    public int createGeometryColumns() {
        return this.execSQLScript(GEOMETRY_COLUMNS);
    }

    public int createTileMatrixSet() {
        return this.execSQLScript(TILE_MATRIX_SET);
    }

    public int createTileMatrix() {
        return this.execSQLScript(TILE_MATRIX);
    }

    public int createDataColumns() {
        return this.execSQLScript(DATA_COLUMNS);
    }

    public int createDataColumnConstraints() {
        return this.execSQLScript(DATA_COLUMN_CONSTRAINTS);
    }

    public int createMetadata() {
        return this.execSQLScript(METADATA);
    }

    public int createMetadataReference() {
        return this.execSQLScript(METADATA_REFERENCE);
    }

    public int createExtensions() {
        return this.execSQLScript(EXTENSIONS);
    }

    public int createGriddedCoverage() {
        return this.execSQLScript(GRIDDED_COVERAGE);
    }

    public int createGriddedTile() {
        return this.execSQLScript(GRIDDED_TILE);
    }

    public int createExtendedRelations() {
        return this.execSQLScript(EXTENDED_RELATIONS);
    }

    public int createTableIndex() {
        return this.execSQLScript(TABLE_INDEX);
    }

    public int createGeometryIndex() {
        return this.execSQLScript(GEOMETRY_INDEX) + this.indexGeometryIndex();
    }

    public int indexGeometryIndex() {
        return this.execSQLScript(INDEX_GEOMETRY_INDEX);
    }

    public int unindexGeometryIndex() {
        return this.execSQLScript(UNINDEX_GEOMETRY_INDEX);
    }

    public int createFeatureTileLink() {
        return this.execSQLScript(FEATURE_TILE_LINK);
    }

    public int createTileScaling() {
        return this.execSQLScript(TILE_SCALING);
    }

    public int createContentsId() {
        return this.execSQLScript(CONTENTS_ID);
    }

    public int execSQLScript(String sqlScript) {
        List<String> statements = GeoPackageTableCreator.readSQLScript(sqlScript);
        for (String statement : statements) {
            this.db.execSQL(statement);
        }
        return statements.size();
    }

    public static List<String> readSQLScript(String sqlScript) {
        String path = GeoPackageProperties.getProperty("sql", "directory");
        List<String> statements = ResourceIOUtils.parseSQLStatements(path, sqlScript);
        return statements;
    }

    public <TColumn extends UserColumn> void createTable(UserTable<TColumn> table) {
        if (this.db.tableExists(table.getTableName())) {
            throw new GeoPackageException("Table already exists and can not be created: " + table.getTableName());
        }
        String sql = CoreSQLUtils.createTableSQL(table);
        this.db.execSQL(sql);
    }

    public void createRequired() {
        this.createSpatialReferenceSystem();
        this.createContents();
        try {
            SpatialReferenceSystemDao dao = (SpatialReferenceSystemDao)DaoManager.createDao((ConnectionSource)this.db.getConnectionSource(), SpatialReferenceSystem.class);
            dao.createWgs84();
            dao.createUndefinedCartesian();
            dao.createUndefinedGeographic();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Error creating default required Spatial Reference Systems", e);
        }
    }

    public void dropTable(String table) {
        CoreSQLUtils.dropTable(this.db, table);
    }
}

