/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.Locale;

public enum GeoPackageDataType {
    BOOLEAN(Boolean.class),
    TINYINT(Byte.class),
    SMALLINT(Short.class),
    MEDIUMINT(Integer.class),
    INT(Long.class),
    INTEGER(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class),
    REAL(Double.class),
    TEXT(String.class),
    BLOB(byte[].class),
    DATE(String.class),
    DATETIME(String.class);

    private final Class<?> classType;

    private GeoPackageDataType(Class<?> classType) {
        this.classType = classType;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public static GeoPackageDataType fromName(String name) {
        return GeoPackageDataType.valueOf(name.toUpperCase(Locale.US));
    }

    public static GeoPackageDataType findName(String name) {
        GeoPackageDataType type = null;
        for (GeoPackageDataType dataType : GeoPackageDataType.values()) {
            if (!dataType.name().equalsIgnoreCase(name)) continue;
            type = dataType;
            break;
        }
        return type;
    }
}

