/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.TableMapping;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;
import mil.nga.geopackage.db.master.SQLiteMasterType;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.RawConstraint;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;

public class AlterTable {
    private static final Logger logger = Logger.getLogger(AlterTable.class.getName());

    public static String alterTable(String table) {
        return "ALTER TABLE " + CoreSQLUtils.quoteWrap(table);
    }

    public static void renameTable(GeoPackageCoreConnection db, String tableName, String newTableName) {
        String sql = AlterTable.renameTableSQL(tableName, newTableName);
        db.execSQL(sql);
    }

    public static String renameTableSQL(String tableName, String newTableName) {
        return AlterTable.alterTable(tableName) + " RENAME TO " + CoreSQLUtils.quoteWrap(newTableName);
    }

    public static void renameColumn(GeoPackageCoreConnection db, String tableName, String columnName, String newColumnName) {
        String sql = AlterTable.renameColumnSQL(tableName, columnName, newColumnName);
        db.execSQL(sql);
    }

    public static String renameColumnSQL(String tableName, String columnName, String newColumnName) {
        return AlterTable.alterTable(tableName) + " RENAME COLUMN " + CoreSQLUtils.quoteWrap(columnName) + " TO " + CoreSQLUtils.quoteWrap(newColumnName);
    }

    public static void addColumn(GeoPackageCoreConnection db, String tableName, String columnName, String columnDef) {
        String sql = AlterTable.addColumnSQL(tableName, columnName, columnDef);
        db.execSQL(sql);
    }

    public static String addColumnSQL(String tableName, String columnName, String columnDef) {
        return AlterTable.alterTable(tableName) + " ADD COLUMN " + CoreSQLUtils.quoteWrap(columnName) + " " + columnDef;
    }

    public static void dropColumn(GeoPackageCoreConnection db, UserTable<? extends UserColumn> table, String columnName) {
        AlterTable.dropColumns(db, table, Arrays.asList(columnName));
    }

    public static void dropColumns(GeoPackageCoreConnection db, UserTable<? extends UserColumn> table, Collection<String> columnNames) {
        UserTable<? extends UserColumn> newTable = table.copy();
        for (String columnName : columnNames) {
            newTable.dropColumn(columnName);
        }
        TableMapping tableMapping = new TableMapping(newTable, columnNames);
        AlterTable.alterTable(db, newTable, tableMapping);
        for (String columnName : columnNames) {
            table.dropColumn(columnName);
        }
    }

    public static void dropColumn(GeoPackageCoreConnection db, String tableName, String columnName) {
        AlterTable.dropColumns(db, tableName, Arrays.asList(columnName));
    }

    public static void dropColumns(GeoPackageCoreConnection db, String tableName, Collection<String> columnNames) {
        UserCustomTable userTable = UserCustomTableReader.readTable(db, tableName);
        AlterTable.dropColumns(db, userTable, columnNames);
    }

    public static <T extends UserColumn> void alterColumn(GeoPackageCoreConnection db, UserTable<T> table, T column) {
        AlterTable.alterColumns(db, table, Arrays.asList(column));
    }

    public static <T extends UserColumn> void alterColumns(GeoPackageCoreConnection db, UserTable<T> table, Collection<T> columns) {
        UserTable<T> newTable = table.copy();
        for (UserColumn column : columns) {
            newTable.alterColumn(column);
        }
        AlterTable.alterTable(db, newTable);
        for (UserColumn column : columns) {
            table.alterColumn(column);
        }
    }

    public static <T extends UserColumn> void alterColumn(GeoPackageCoreConnection db, String tableName, UserCustomColumn column) {
        AlterTable.alterColumns(db, tableName, Arrays.asList(column));
    }

    public static <T extends UserColumn> void alterColumns(GeoPackageCoreConnection db, String tableName, Collection<UserCustomColumn> columns) {
        UserCustomTable userTable = UserCustomTableReader.readTable(db, tableName);
        AlterTable.alterColumns(db, userTable, columns);
    }

    public static void copyTable(GeoPackageCoreConnection db, UserTable<? extends UserColumn> table, String newTableName) {
        AlterTable.copyTable(db, table, newTableName, true);
    }

    public static void copyTable(GeoPackageCoreConnection db, UserTable<? extends UserColumn> table, String newTableName, boolean transferContent) {
        TableMapping tableMapping = new TableMapping(table, newTableName);
        tableMapping.setTransferContent(transferContent);
        AlterTable.alterTable(db, table, tableMapping);
    }

    public static void copyTable(GeoPackageCoreConnection db, String tableName, String newTableName) {
        AlterTable.copyTable(db, tableName, newTableName, true);
    }

    public static void copyTable(GeoPackageCoreConnection db, String tableName, String newTableName, boolean transferContent) {
        UserCustomTable userTable = UserCustomTableReader.readTable(db, tableName);
        AlterTable.copyTable(db, userTable, newTableName, transferContent);
    }

    public static void alterTable(GeoPackageCoreConnection db, UserTable<? extends UserColumn> newTable) {
        TableMapping tableMapping = new TableMapping(newTable);
        AlterTable.alterTable(db, newTable, tableMapping);
    }

    public static void alterTable(GeoPackageCoreConnection db, UserTable<? extends UserColumn> newTable, TableMapping tableMapping) {
        for (UserColumn userColumn : newTable.getColumns()) {
            List<Constraint> columnConstraints = userColumn.clearConstraints();
            for (Constraint columnConstraint : columnConstraints) {
                String updatedSql = CoreSQLUtils.modifySQL(columnConstraint.getName(), columnConstraint.buildSql(), tableMapping);
                if (updatedSql == null) continue;
                userColumn.addConstraint(new RawConstraint(columnConstraint.getType(), updatedSql));
            }
        }
        List<Constraint> tableContraints = newTable.clearConstraints();
        for (Constraint tableConstraint : tableContraints) {
            String updatedSql = CoreSQLUtils.modifySQL(tableConstraint.getName(), tableConstraint.buildSql(), tableMapping);
            if (updatedSql == null) continue;
            newTable.addConstraint(new RawConstraint(tableConstraint.getType(), updatedSql));
        }
        String string = CoreSQLUtils.createTableSQL(newTable);
        AlterTable.alterTable(db, string, tableMapping);
    }

    public static void alterTable(GeoPackageCoreConnection db, String sql, TableMapping tableMapping) {
        String tableName = tableMapping.getFromTable();
        boolean newTable = tableMapping.isNewTable();
        boolean enableForeignKeys = CoreSQLUtils.foreignKeys(db, false);
        boolean successful = true;
        db.beginTransaction();
        try {
            int i;
            String transferTable;
            SQLiteMaster views = SQLiteMaster.queryViewsOnTable(db, SQLiteMaster.columns(SQLiteMasterColumn.NAME, SQLiteMasterColumn.SQL), tableName);
            if (!newTable) {
                for (int i2 = 0; i2 < views.count(); ++i2) {
                    String viewName = views.getName(i2);
                    try {
                        CoreSQLUtils.dropView(db, viewName);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Failed to drop view: " + viewName + ", table: " + tableName, e);
                    }
                }
            }
            SQLiteMaster indexesAndTriggers = SQLiteMaster.query(db, SQLiteMaster.columns(SQLiteMasterColumn.NAME, SQLiteMasterColumn.TYPE, SQLiteMasterColumn.SQL), SQLiteMaster.types(SQLiteMasterType.INDEX, SQLiteMasterType.TRIGGER), tableName);
            if (newTable) {
                transferTable = tableMapping.getToTable();
            } else {
                transferTable = CoreSQLUtils.tempTableName(db, "new", tableName);
                tableMapping.setToTable(transferTable);
            }
            sql = sql.replaceFirst(tableName, transferTable);
            db.execSQL(sql);
            if (tableMapping.isTransferContent()) {
                CoreSQLUtils.transferTableContent(db, tableMapping);
            }
            if (!newTable) {
                CoreSQLUtils.dropTable(db, tableName);
                AlterTable.renameTable(db, transferTable, tableName);
                tableMapping.setToTable(tableName);
            }
            for (i = 0; i < indexesAndTriggers.count(); ++i) {
                String tableSql;
                boolean create;
                boolean bl = create = !newTable;
                if (!create) {
                    boolean bl2 = create = indexesAndTriggers.getType(i) != SQLiteMasterType.TRIGGER || !indexesAndTriggers.getName(i).startsWith("rtree_");
                }
                if (!create || (tableSql = indexesAndTriggers.getSql(i)) == null || (tableSql = CoreSQLUtils.modifySQL(db, indexesAndTriggers.getName(i), tableSql, tableMapping)) == null) continue;
                try {
                    db.execSQL(tableSql);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to recreate " + (Object)((Object)indexesAndTriggers.getType(i)) + " after table alteration. table: " + tableMapping.getToTable() + ", sql: " + tableSql, e);
                }
            }
            for (i = 0; i < views.count(); ++i) {
                String viewSql = views.getSql(i);
                if (viewSql == null || (viewSql = CoreSQLUtils.modifySQL(db, views.getName(i), viewSql, tableMapping)) == null) continue;
                try {
                    db.execSQL(viewSql);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to recreate view: " + views.getName(i) + ", table: " + tableMapping.getToTable() + ", sql: " + viewSql, e);
                }
            }
            if (enableForeignKeys) {
                AlterTable.foreignKeyCheck(db);
            }
        }
        catch (Throwable e) {
            successful = false;
            throw e;
        }
        finally {
            db.endTransaction(successful);
        }
        if (enableForeignKeys) {
            CoreSQLUtils.foreignKeys(db, true);
        }
    }

    private static void foreignKeyCheck(GeoPackageCoreConnection db) {
        List<List<Object>> violations = CoreSQLUtils.foreignKeyCheck(db);
        if (!violations.isEmpty()) {
            StringBuilder violationsMessage = new StringBuilder();
            for (int i = 0; i < violations.size(); ++i) {
                if (i > 0) {
                    violationsMessage.append("; ");
                }
                violationsMessage.append(i + 1).append(": ");
                List<Object> violation = violations.get(i);
                for (int j = 0; j < violation.size(); ++j) {
                    if (j > 0) {
                        violationsMessage.append(", ");
                    }
                    violationsMessage.append(violation.get(j));
                }
            }
            throw new GeoPackageException("Foreign Key Check Violations: " + violationsMessage);
        }
    }
}

