/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import mil.nga.tiff.FieldType;
import mil.nga.tiff.FileDirectory;
import mil.nga.tiff.FileDirectoryEntry;
import mil.nga.tiff.Rasters;
import mil.nga.tiff.TIFFImage;
import mil.nga.tiff.compression.CompressionEncoder;
import mil.nga.tiff.compression.DeflateCompression;
import mil.nga.tiff.compression.LZWCompression;
import mil.nga.tiff.compression.PackbitsCompression;
import mil.nga.tiff.compression.RawCompression;
import mil.nga.tiff.io.ByteWriter;
import mil.nga.tiff.io.IOUtils;
import mil.nga.tiff.util.TiffException;

public class TiffWriter {
    public static void writeTiff(File file, TIFFImage tiffImage) throws IOException {
        ByteWriter writer = new ByteWriter();
        TiffWriter.writeTiff(file, writer, tiffImage);
        writer.close();
    }

    public static void writeTiff(File file, ByteWriter writer, TIFFImage tiffImage) throws IOException {
        byte[] bytes = TiffWriter.writeTiffToBytes(writer, tiffImage);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        IOUtils.copyStream((InputStream)inputStream, file);
    }

    public static byte[] writeTiffToBytes(TIFFImage tiffImage) throws IOException {
        ByteWriter writer = new ByteWriter();
        byte[] bytes = TiffWriter.writeTiffToBytes(writer, tiffImage);
        writer.close();
        return bytes;
    }

    public static byte[] writeTiffToBytes(ByteWriter writer, TIFFImage tiffImage) throws IOException {
        TiffWriter.writeTiff(writer, tiffImage);
        byte[] bytes = writer.getBytes();
        return bytes;
    }

    public static void writeTiff(ByteWriter writer, TIFFImage tiffImage) throws IOException {
        String byteOrder = writer.getByteOrder() == ByteOrder.BIG_ENDIAN ? "MM" : "II";
        writer.writeString(byteOrder);
        writer.writeUnsignedShort(42);
        writer.writeUnsignedInt(8L);
        TiffWriter.writeImageFileDirectories(writer, tiffImage);
    }

    private static void writeImageFileDirectories(ByteWriter writer, TIFFImage tiffImage) throws IOException {
        for (int i = 0; i < tiffImage.getFileDirectories().size(); ++i) {
            int bytesWritten;
            FileDirectory fileDirectory = tiffImage.getFileDirectories().get(i);
            TiffWriter.populateRasterEntries(fileDirectory);
            int startOfDirectory = writer.size();
            long afterDirectory = (long)startOfDirectory + fileDirectory.size();
            long afterValues = (long)startOfDirectory + fileDirectory.sizeWithValues();
            writer.writeUnsignedShort(fileDirectory.numEntries());
            ArrayList<FileDirectoryEntry> entryValues = new ArrayList<FileDirectoryEntry>();
            long nextByte = afterDirectory;
            ArrayList<Long> valueBytesCheck = new ArrayList<Long>();
            if (fileDirectory.isTiled()) {
                throw new TiffException("Tiled images are not supported");
            }
            byte[] rastersBytes = TiffWriter.writeRasters(writer.getByteOrder(), fileDirectory, afterValues);
            for (FileDirectoryEntry entry : fileDirectory.getEntries()) {
                writer.writeUnsignedShort(entry.getFieldTag().getId());
                writer.writeUnsignedShort(entry.getFieldType().getValue());
                writer.writeUnsignedInt(entry.getTypeCount());
                long valueBytes = (long)entry.getFieldType().getBytes() * entry.getTypeCount();
                if (valueBytes > 4L) {
                    entryValues.add(entry);
                    writer.writeUnsignedInt(nextByte);
                    valueBytesCheck.add(nextByte);
                    nextByte += entry.sizeOfValues();
                    continue;
                }
                bytesWritten = TiffWriter.writeValues(writer, entry);
                if ((long)bytesWritten != valueBytes) {
                    throw new TiffException("Unexpected bytes written. Expected: " + valueBytes + ", Actual: " + bytesWritten);
                }
                TiffWriter.writeFillerBytes(writer, 4L - valueBytes);
            }
            if (i + 1 == tiffImage.getFileDirectories().size()) {
                TiffWriter.writeFillerBytes(writer, 4L);
            } else {
                long nextFileDirectory = afterValues + (long)rastersBytes.length;
                writer.writeUnsignedInt(nextFileDirectory);
            }
            for (int entryIndex = 0; entryIndex < entryValues.size(); ++entryIndex) {
                long valueBytes;
                FileDirectoryEntry entry;
                entry = (FileDirectoryEntry)entryValues.get(entryIndex);
                long entryValuesByte = (Long)valueBytesCheck.get(entryIndex);
                if (entryValuesByte != (long)writer.size()) {
                    throw new TiffException("Entry values byte does not match the write location. Entry Values Byte: " + entryValuesByte + ", Current Byte: " + writer.size());
                }
                bytesWritten = TiffWriter.writeValues(writer, entry);
                if ((long)bytesWritten == (valueBytes = (long)entry.getFieldType().getBytes() * entry.getTypeCount())) continue;
                throw new TiffException("Unexpected bytes written. Expected: " + valueBytes + ", Actual: " + bytesWritten);
            }
            writer.writeBytes(rastersBytes);
        }
    }

    private static void populateRasterEntries(FileDirectory fileDirectory) {
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            throw new TiffException("File Directory Writer Rasters is required to create a TIFF");
        }
        if (fileDirectory.isTiled()) {
            throw new TiffException("Tiled images are not supported");
        }
        TiffWriter.populateStripEntries(fileDirectory);
    }

    private static void populateStripEntries(FileDirectory fileDirectory) {
        int stripsPerSample;
        int rowsPerStrip = fileDirectory.getRowsPerStrip().intValue();
        int imageHeight = fileDirectory.getImageHeight().intValue();
        int strips = stripsPerSample = (imageHeight + rowsPerStrip - 1) / rowsPerStrip;
        if (fileDirectory.getPlanarConfiguration() == 2) {
            strips *= fileDirectory.getSamplesPerPixel();
        }
        fileDirectory.setStripOffsetsAsLongs(new ArrayList<Long>(Collections.nCopies(strips, 0L)));
        fileDirectory.setStripByteCounts(new ArrayList<Integer>(Collections.nCopies(strips, 0)));
    }

    private static byte[] writeRasters(ByteOrder byteOrder, FileDirectory fileDirectory, long offset) throws IOException {
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            throw new TiffException("File Directory Writer Rasters is required to create a TIFF");
        }
        CompressionEncoder encoder = TiffWriter.getEncoder(fileDirectory);
        ByteWriter writer = new ByteWriter(byteOrder);
        if (fileDirectory.isTiled()) {
            throw new TiffException("Tiled images are not supported");
        }
        TiffWriter.writeStripRasters(writer, fileDirectory, offset, encoder);
        byte[] bytes = writer.getBytes();
        writer.close();
        return bytes;
    }

    private static void writeStripRasters(ByteWriter writer, FileDirectory fileDirectory, long offset, CompressionEncoder encoder) throws IOException {
        int stripsPerSample;
        Rasters rasters = fileDirectory.getWriteRasters();
        int rowsPerStrip = fileDirectory.getRowsPerStrip().intValue();
        int maxY = fileDirectory.getImageHeight().intValue();
        int strips = stripsPerSample = (maxY + rowsPerStrip - 1) / rowsPerStrip;
        if (fileDirectory.getPlanarConfiguration() == 2) {
            strips *= fileDirectory.getSamplesPerPixel();
        }
        ArrayList<Long> stripOffsets = new ArrayList<Long>();
        ArrayList<Integer> stripByteCounts = new ArrayList<Integer>();
        for (int strip = 0; strip < strips; ++strip) {
            int startingY;
            Integer sample = null;
            if (fileDirectory.getPlanarConfiguration() == 2) {
                sample = strip / stripsPerSample;
                startingY = strip % stripsPerSample * rowsPerStrip;
            } else {
                startingY = strip * rowsPerStrip;
            }
            ByteWriter stripWriter = new ByteWriter(writer.getByteOrder());
            int endingY = Math.min(startingY + rowsPerStrip, maxY);
            for (int y = startingY; y < endingY; ++y) {
                byte[] rowBytes = null;
                rowBytes = sample != null ? rasters.getSampleRow(y, sample, writer.getByteOrder()) : rasters.getPixelRow(y, writer.getByteOrder());
                if (encoder.rowEncoding()) {
                    rowBytes = encoder.encode(rowBytes, writer.getByteOrder());
                }
                stripWriter.writeBytes(rowBytes);
            }
            byte[] stripBytes = stripWriter.getBytes();
            stripWriter.close();
            if (!encoder.rowEncoding()) {
                stripBytes = encoder.encode(stripBytes, writer.getByteOrder());
            }
            writer.writeBytes(stripBytes);
            int bytesWritten = stripBytes.length;
            stripByteCounts.add(bytesWritten);
            stripOffsets.add(offset);
            offset += (long)bytesWritten;
        }
        fileDirectory.setStripOffsetsAsLongs(stripOffsets);
        fileDirectory.setStripByteCounts(stripByteCounts);
    }

    private static CompressionEncoder getEncoder(FileDirectory fileDirectory) {
        CompressionEncoder encoder = null;
        Integer compression = fileDirectory.getCompression();
        if (compression == null) {
            compression = 1;
        }
        switch (compression) {
            case 1: {
                encoder = new RawCompression();
                break;
            }
            case 2: {
                throw new TiffException("CCITT Huffman compression not supported: " + compression);
            }
            case 3: {
                throw new TiffException("T4-encoding compression not supported: " + compression);
            }
            case 4: {
                throw new TiffException("T6-encoding compression not supported: " + compression);
            }
            case 5: {
                encoder = new LZWCompression();
                break;
            }
            case 6: 
            case 7: {
                throw new TiffException("JPEG compression not supported: " + compression);
            }
            case 8: 
            case 32946: {
                encoder = new DeflateCompression();
                break;
            }
            case 32773: {
                encoder = new PackbitsCompression();
                break;
            }
            default: {
                throw new TiffException("Unknown compression method identifier: " + compression);
            }
        }
        return encoder;
    }

    private static void writeFillerBytes(ByteWriter writer, long count) {
        for (long i = 0L; i < count; ++i) {
            writer.writeUnsignedByte((short)0);
        }
    }

    private static int writeValues(ByteWriter writer, FileDirectoryEntry entry) throws IOException {
        ArrayList<Object> valuesList = null;
        if (entry.getTypeCount() == 1L && !entry.getFieldTag().isArray() && entry.getFieldType() != FieldType.RATIONAL && entry.getFieldType() != FieldType.SRATIONAL) {
            valuesList = new ArrayList<Object>();
            valuesList.add(entry.getValues());
        } else {
            valuesList = (ArrayList<Object>)entry.getValues();
        }
        int bytesWritten = 0;
        block13: for (Object e : valuesList) {
            switch (entry.getFieldType()) {
                case ASCII: {
                    if ((long)(bytesWritten += writer.writeString((String)e)) >= entry.getTypeCount()) continue block13;
                    long fillerBytes = entry.getTypeCount() - (long)bytesWritten;
                    TiffWriter.writeFillerBytes(writer, fillerBytes);
                    bytesWritten = (int)((long)bytesWritten + fillerBytes);
                    continue block13;
                }
                case BYTE: 
                case UNDEFINED: {
                    writer.writeUnsignedByte((Short)e);
                    ++bytesWritten;
                    continue block13;
                }
                case SBYTE: {
                    writer.writeByte((Byte)e);
                    ++bytesWritten;
                    continue block13;
                }
                case SHORT: {
                    writer.writeUnsignedShort((Integer)e);
                    bytesWritten += 2;
                    continue block13;
                }
                case SSHORT: {
                    writer.writeShort((Short)e);
                    bytesWritten += 2;
                    continue block13;
                }
                case LONG: {
                    writer.writeUnsignedInt((Long)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case SLONG: {
                    writer.writeInt((Integer)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case RATIONAL: {
                    writer.writeUnsignedInt((Long)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case SRATIONAL: {
                    writer.writeInt((Integer)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case FLOAT: {
                    writer.writeFloat(((Float)e).floatValue());
                    bytesWritten += 4;
                    continue block13;
                }
                case DOUBLE: {
                    writer.writeDouble((Double)e);
                    bytesWritten += 8;
                    continue block13;
                }
            }
            throw new TiffException("Invalid field type: " + (Object)((Object)entry.getFieldType()));
        }
        return bytesWritten;
    }
}

