/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.util;

import java.util.Arrays;

public class IntArrayList {
    private int[] data;
    private int size = 0;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public int size() {
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= this.data.length) {
            return;
        }
        int newLength = Math.max(capacity, this.data.length * 2);
        this.data = Arrays.copyOf(this.data, newLength);
    }

    public void add(int value) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size] = value;
        ++this.size;
    }

    public void addAll(int[] values) {
        if (values == null) {
            return;
        }
        if (values.length == 0) {
            return;
        }
        this.ensureCapacity(this.size + values.length);
        System.arraycopy(values, 0, this.data, this.size, values.length);
        this.size += values.length;
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }
}

