/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.valid;

import java.util.List;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.Envelope;
import shadow.org.locationtech.jts.geom.LinearRing;
import shadow.org.locationtech.jts.geom.Polygon;
import shadow.org.locationtech.jts.index.SpatialIndex;
import shadow.org.locationtech.jts.index.strtree.STRtree;
import shadow.org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;

class IndexedNestedHoleTester {
    private Polygon polygon;
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedHoleTester(Polygon poly) {
        this.polygon = poly;
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            Envelope env = hole.getEnvelopeInternal();
            this.index.insert(env, hole);
        }
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNested() {
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            List results = this.index.query(hole.getEnvelopeInternal());
            for (LinearRing testHole : results) {
                Coordinate holePt1;
                Coordinate holePt0;
                if (hole == testHole || !testHole.getEnvelopeInternal().covers(hole.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.isSegmentInRing(holePt0 = hole.getCoordinateN(0), holePt1 = hole.getCoordinateN(1), testHole)) continue;
                this.nestedPt = holePt0;
                return true;
            }
        }
        return false;
    }
}

