/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.predicate;

import java.util.List;
import shadow.org.locationtech.jts.algorithm.RectangleLineIntersector;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateSequence;
import shadow.org.locationtech.jts.geom.Envelope;
import shadow.org.locationtech.jts.geom.Geometry;
import shadow.org.locationtech.jts.geom.LineString;
import shadow.org.locationtech.jts.geom.Polygon;
import shadow.org.locationtech.jts.geom.util.LinearComponentExtracter;
import shadow.org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;

class RectangleIntersectsSegmentVisitor
extends ShortCircuitedGeometryVisitor {
    private Envelope rectEnv;
    private RectangleLineIntersector rectIntersector;
    private boolean hasIntersection = false;
    private Coordinate p0 = new Coordinate();
    private Coordinate p1 = new Coordinate();

    public RectangleIntersectsSegmentVisitor(Polygon rectangle) {
        this.rectEnv = rectangle.getEnvelopeInternal();
        this.rectIntersector = new RectangleLineIntersector(this.rectEnv);
    }

    public boolean intersects() {
        return this.hasIntersection;
    }

    @Override
    protected void visit(Geometry geom) {
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        List lines = LinearComponentExtracter.getLines(geom);
        this.checkIntersectionWithLineStrings(lines);
    }

    private void checkIntersectionWithLineStrings(List lines) {
        for (LineString testLine : lines) {
            this.checkIntersectionWithSegments(testLine);
            if (!this.hasIntersection) continue;
            return;
        }
    }

    private void checkIntersectionWithSegments(LineString testLine) {
        CoordinateSequence seq1 = testLine.getCoordinateSequence();
        for (int j = 1; j < seq1.size(); ++j) {
            seq1.getCoordinate(j - 1, this.p0);
            seq1.getCoordinate(j, this.p1);
            if (!this.rectIntersector.intersects(this.p0, this.p1)) continue;
            this.hasIntersection = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.hasIntersection;
    }
}

