/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.predicate;

import shadow.org.locationtech.jts.geom.Envelope;
import shadow.org.locationtech.jts.geom.Geometry;
import shadow.org.locationtech.jts.geom.Polygon;
import shadow.org.locationtech.jts.operation.predicate.EnvelopeIntersectsVisitor;
import shadow.org.locationtech.jts.operation.predicate.GeometryContainsPointVisitor;
import shadow.org.locationtech.jts.operation.predicate.RectangleIntersectsSegmentVisitor;

public class RectangleIntersects {
    private Polygon rectangle;
    private Envelope rectEnv;

    public static boolean intersects(Polygon rectangle, Geometry b) {
        RectangleIntersects rp = new RectangleIntersects(rectangle);
        return rp.intersects(b);
    }

    public RectangleIntersects(Polygon rectangle) {
        this.rectangle = rectangle;
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean intersects(Geometry geom) {
        if (!this.rectEnv.intersects(geom.getEnvelopeInternal())) {
            return false;
        }
        EnvelopeIntersectsVisitor visitor = new EnvelopeIntersectsVisitor(this.rectEnv);
        visitor.applyTo(geom);
        if (visitor.intersects()) {
            return true;
        }
        GeometryContainsPointVisitor ecpVisitor = new GeometryContainsPointVisitor(this.rectangle);
        ecpVisitor.applyTo(geom);
        if (ecpVisitor.containsPoint()) {
            return true;
        }
        RectangleIntersectsSegmentVisitor riVisitor = new RectangleIntersectsSegmentVisitor(this.rectangle);
        riVisitor.applyTo(geom);
        return riVisitor.intersects();
    }
}

