/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import shadow.org.locationtech.jts.algorithm.Orientation;
import shadow.org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import shadow.org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateArrays;
import shadow.org.locationtech.jts.geom.CoordinateList;
import shadow.org.locationtech.jts.geom.Envelope;
import shadow.org.locationtech.jts.geom.GeometryFactory;
import shadow.org.locationtech.jts.geom.LinearRing;
import shadow.org.locationtech.jts.geom.Polygon;
import shadow.org.locationtech.jts.geom.TopologyException;
import shadow.org.locationtech.jts.operation.overlayng.OverlayEdge;

class OverlayEdgeRing {
    private OverlayEdge startEdge;
    private LinearRing ring;
    private boolean isHole;
    private Coordinate[] ringPts;
    private IndexedPointInAreaLocator locator;
    private OverlayEdgeRing shell;
    private List<OverlayEdgeRing> holes = new ArrayList<OverlayEdgeRing>();

    public OverlayEdgeRing(OverlayEdge start, GeometryFactory geometryFactory) {
        this.startEdge = start;
        this.ringPts = this.computeRingPts(start);
        this.computeRing(this.ringPts, geometryFactory);
    }

    public LinearRing getRing() {
        return this.ring;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public void setShell(OverlayEdgeRing shell) {
        this.shell = shell;
        if (shell != null) {
            shell.addHole(this);
        }
    }

    public boolean hasShell() {
        return this.shell != null;
    }

    public OverlayEdgeRing getShell() {
        if (this.isHole()) {
            return this.shell;
        }
        return this;
    }

    public void addHole(OverlayEdgeRing ring) {
        this.holes.add(ring);
    }

    private Coordinate[] computeRingPts(OverlayEdge start) {
        OverlayEdge edge = start;
        CoordinateList pts = new CoordinateList();
        do {
            if (edge.getEdgeRing() == this) {
                throw new TopologyException("Edge visited twice during ring-building at " + edge.getCoordinate(), edge.getCoordinate());
            }
            edge.addCoordinates(pts);
            edge.setEdgeRing(this);
            if (edge.nextResult() != null) continue;
            throw new TopologyException("Found null edge in ring", edge.dest());
        } while ((edge = edge.nextResult()) != start);
        pts.closeRing();
        return pts.toCoordinateArray();
    }

    private void computeRing(Coordinate[] ringPts, GeometryFactory geometryFactory) {
        if (this.ring != null) {
            return;
        }
        this.ring = geometryFactory.createLinearRing(ringPts);
        this.isHole = Orientation.isCCW(this.ring.getCoordinates());
    }

    private Coordinate[] getCoordinates() {
        return this.ringPts;
    }

    public OverlayEdgeRing findEdgeRingContaining(List<OverlayEdgeRing> erList) {
        LinearRing testRing = this.getRing();
        Envelope testEnv = testRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        OverlayEdgeRing minRing = null;
        Envelope minRingEnv = null;
        for (OverlayEdgeRing tryEdgeRing : erList) {
            boolean isContained;
            LinearRing tryRing = tryEdgeRing.getRing();
            Envelope tryShellEnv = tryRing.getEnvelopeInternal();
            if (tryShellEnv.equals(testEnv) || !tryShellEnv.contains(testEnv) || !(isContained = tryEdgeRing.isInRing(testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryEdgeRing.getCoordinates()))) || minRing != null && !minRingEnv.contains(tryShellEnv)) continue;
            minRing = tryEdgeRing;
            minRingEnv = minRing.getRing().getEnvelopeInternal();
        }
        return minRing;
    }

    private PointOnGeometryLocator getLocator() {
        if (this.locator == null) {
            this.locator = new IndexedPointInAreaLocator(this.getRing());
        }
        return this.locator;
    }

    public boolean isInRing(Coordinate pt) {
        return 2 != this.getLocator().locate(pt);
    }

    public Coordinate getCoordinate() {
        return this.ringPts[0];
    }

    public Polygon toPolygon(GeometryFactory factory) {
        LinearRing[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                holeLR[i] = this.holes.get(i).getRing();
            }
        }
        Polygon poly = factory.createPolygon(this.ring, holeLR);
        return poly;
    }

    public OverlayEdge getEdge() {
        return this.startEdge;
    }
}

