/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateList;
import shadow.org.locationtech.jts.geom.Envelope;

public class LineLimiter {
    private Envelope limitEnv;
    private CoordinateList ptList;
    private Coordinate lastOutside = null;
    private List<Coordinate[]> sections = null;

    public LineLimiter(Envelope env) {
        this.limitEnv = env;
    }

    public List<Coordinate[]> limit(Coordinate[] pts) {
        this.lastOutside = null;
        this.ptList = null;
        this.sections = new ArrayList<Coordinate[]>();
        for (int i = 0; i < pts.length; ++i) {
            Coordinate p = pts[i];
            if (this.limitEnv.intersects(p)) {
                this.addPoint(p);
                continue;
            }
            this.addOutside(p);
        }
        this.finishSection();
        return this.sections;
    }

    private void addPoint(Coordinate p) {
        if (p == null) {
            return;
        }
        this.startSection();
        this.ptList.add(p, false);
    }

    private void addOutside(Coordinate p) {
        boolean segIntersects = this.isLastSegmentIntersecting(p);
        if (!segIntersects) {
            this.finishSection();
        } else {
            this.addPoint(this.lastOutside);
            this.addPoint(p);
        }
        this.lastOutside = p;
    }

    private boolean isLastSegmentIntersecting(Coordinate p) {
        if (this.lastOutside == null) {
            return this.isSectionOpen();
        }
        return this.limitEnv.intersects(this.lastOutside, p);
    }

    private boolean isSectionOpen() {
        return this.ptList != null;
    }

    private void startSection() {
        if (this.ptList == null) {
            this.ptList = new CoordinateList();
        }
        if (this.lastOutside != null) {
            this.ptList.add(this.lastOutside, false);
        }
        this.lastOutside = null;
    }

    private void finishSection() {
        if (this.ptList == null) {
            return;
        }
        if (this.lastOutside != null) {
            this.ptList.add(this.lastOutside, false);
            this.lastOutside = null;
        }
        Coordinate[] section = this.ptList.toCoordinateArray();
        this.sections.add(section);
        this.ptList = null;
    }
}

