/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateList;
import shadow.org.locationtech.jts.geom.GeometryFactory;
import shadow.org.locationtech.jts.geom.LineString;
import shadow.org.locationtech.jts.operation.overlayng.InputGeometry;
import shadow.org.locationtech.jts.operation.overlayng.OverlayEdge;
import shadow.org.locationtech.jts.operation.overlayng.OverlayGraph;
import shadow.org.locationtech.jts.operation.overlayng.OverlayLabel;
import shadow.org.locationtech.jts.operation.overlayng.OverlayNG;

class LineBuilder {
    private GeometryFactory geometryFactory;
    private OverlayGraph graph;
    private int opCode;
    private int inputAreaIndex;
    private boolean hasResultArea;
    private boolean isAllowMixedResult = true;
    private boolean isAllowCollapseLines = true;
    private List<LineString> lines = new ArrayList<LineString>();

    public LineBuilder(InputGeometry inputGeom, OverlayGraph graph, boolean hasResultArea, int opCode, GeometryFactory geomFact) {
        this.graph = graph;
        this.opCode = opCode;
        this.geometryFactory = geomFact;
        this.hasResultArea = hasResultArea;
        this.inputAreaIndex = inputGeom.getAreaIndex();
    }

    public void setStrictMode(boolean isStrictResultMode) {
        this.isAllowCollapseLines = !isStrictResultMode;
        this.isAllowMixedResult = !isStrictResultMode;
    }

    public List<LineString> getLines() {
        this.markResultLines();
        this.addResultLines();
        return this.lines;
    }

    private void markResultLines() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (edge.isInResultEither() || !this.isResultLine(edge.getLabel())) continue;
            edge.markInResultLine();
        }
    }

    private boolean isResultLine(OverlayLabel lbl) {
        if (lbl.isBoundarySingleton()) {
            return false;
        }
        if (!this.isAllowCollapseLines && lbl.isBoundaryCollapse()) {
            return false;
        }
        if (lbl.isInteriorCollapse()) {
            return false;
        }
        if (this.opCode != 1) {
            if (lbl.isCollapseAndNotPartInterior()) {
                return false;
            }
            if (this.hasResultArea && lbl.isLineInArea(this.inputAreaIndex)) {
                return false;
            }
        }
        if (this.isAllowMixedResult && this.opCode == 1 && lbl.isBoundaryTouch()) {
            return true;
        }
        int aLoc = LineBuilder.effectiveLocation(lbl, 0);
        int bLoc = LineBuilder.effectiveLocation(lbl, 1);
        boolean isInResult = OverlayNG.isResultOfOp(this.opCode, aLoc, bLoc);
        return isInResult;
    }

    private static int effectiveLocation(OverlayLabel lbl, int geomIndex) {
        if (lbl.isCollapse(geomIndex)) {
            return 0;
        }
        if (lbl.isLine(geomIndex)) {
            return 0;
        }
        return lbl.getLineLocation(geomIndex);
    }

    private void addResultLines() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (!edge.isInResultLine() || edge.isVisited()) continue;
            this.lines.add(this.toLine(edge));
            edge.markVisitedBoth();
        }
    }

    private LineString toLine(OverlayEdge edge) {
        boolean isForward = edge.isForward();
        CoordinateList pts = new CoordinateList();
        pts.add(edge.orig(), false);
        edge.addCoordinates(pts);
        Coordinate[] ptsOut = pts.toCoordinateArray(isForward);
        LineString line = this.geometryFactory.createLineString(ptsOut);
        return line;
    }

    private void addResultLinesMerged() {
        this.addResultLinesForNodes();
        this.addResultLinesRings();
    }

    private void addResultLinesForNodes() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (!edge.isInResultLine() || edge.isVisited() || LineBuilder.degreeOfLines(edge) == 2) continue;
            this.lines.add(this.buildLine(edge));
        }
    }

    private void addResultLinesRings() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (!edge.isInResultLine() || edge.isVisited()) continue;
            this.lines.add(this.buildLine(edge));
        }
    }

    private LineString buildLine(OverlayEdge node) {
        CoordinateList pts = new CoordinateList();
        pts.add(node.orig(), false);
        boolean isForward = node.isForward();
        OverlayEdge e = node;
        do {
            e.markVisitedBoth();
            e.addCoordinates(pts);
        } while (LineBuilder.degreeOfLines(e.symOE()) == 2 && (e = LineBuilder.nextLineEdgeUnvisited(e.symOE())) != null);
        Coordinate[] ptsOut = pts.toCoordinateArray(isForward);
        LineString line = this.geometryFactory.createLineString(ptsOut);
        return line;
    }

    private static OverlayEdge nextLineEdgeUnvisited(OverlayEdge node) {
        OverlayEdge e = node;
        do {
            if ((e = e.oNextOE()).isVisited() || !e.isInResultLine()) continue;
            return e;
        } while (e != node);
        return null;
    }

    private static int degreeOfLines(OverlayEdge node) {
        int degree = 0;
        OverlayEdge e = node;
        do {
            if (!e.isInResultLine()) continue;
            ++degree;
        } while ((e = e.oNextOE()) != node);
        return degree;
    }
}

