/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.overlayng;

import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.io.WKTWriter;
import shadow.org.locationtech.jts.operation.overlayng.EdgeSourceInfo;
import shadow.org.locationtech.jts.operation.overlayng.OverlayLabel;

class Edge {
    private Coordinate[] pts;
    private int aDim = -1;
    private int aDepthDelta = 0;
    private boolean aIsHole = false;
    private int bDim = -1;
    private int bDepthDelta = 0;
    private boolean bIsHole = false;

    public static boolean isCollapsed(Coordinate[] pts) {
        if (pts.length < 2) {
            return true;
        }
        if (pts[0].equals2D(pts[1])) {
            return true;
        }
        return pts.length > 2 && pts[pts.length - 1].equals2D(pts[pts.length - 2]);
    }

    public Edge(Coordinate[] pts, EdgeSourceInfo info) {
        this.pts = pts;
        this.copyInfo(info);
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getCoordinate(int index) {
        return this.pts[index];
    }

    public int size() {
        return this.pts.length;
    }

    public boolean direction() {
        int cmp1;
        Coordinate[] pts = this.getCoordinates();
        if (pts.length < 2) {
            throw new IllegalStateException("Edge must have >= 2 points");
        }
        Coordinate p0 = pts[0];
        Coordinate p1 = pts[1];
        Coordinate pn0 = pts[pts.length - 1];
        Coordinate pn1 = pts[pts.length - 2];
        int cmp = 0;
        int cmp0 = p0.compareTo(pn0);
        if (cmp0 != 0) {
            cmp = cmp0;
        }
        if (cmp == 0 && (cmp1 = p1.compareTo(pn1)) != 0) {
            cmp = cmp1;
        }
        if (cmp == 0) {
            throw new IllegalStateException("Edge direction cannot be determined because endpoints are equal");
        }
        return cmp == -1;
    }

    public boolean relativeDirection(Edge edge2) {
        if (!this.getCoordinate(0).equals2D(edge2.getCoordinate(0))) {
            return false;
        }
        return this.getCoordinate(1).equals2D(edge2.getCoordinate(1));
    }

    public OverlayLabel createLabel() {
        OverlayLabel lbl = new OverlayLabel();
        Edge.initLabel(lbl, 0, this.aDim, this.aDepthDelta, this.aIsHole);
        Edge.initLabel(lbl, 1, this.bDim, this.bDepthDelta, this.bIsHole);
        return lbl;
    }

    private static void initLabel(OverlayLabel lbl, int geomIndex, int dim, int depthDelta, boolean isHole) {
        int dimLabel = Edge.labelDim(dim, depthDelta);
        switch (dimLabel) {
            case -1: {
                lbl.initNotPart(geomIndex);
                break;
            }
            case 2: {
                lbl.initBoundary(geomIndex, Edge.locationLeft(depthDelta), Edge.locationRight(depthDelta), isHole);
                break;
            }
            case 3: {
                lbl.initCollapse(geomIndex, isHole);
                break;
            }
            case 1: {
                lbl.initLine(geomIndex);
            }
        }
    }

    private static int labelDim(int dim, int depthDelta) {
        boolean isCollapse;
        if (dim == -1) {
            return -1;
        }
        if (dim == 1) {
            return 1;
        }
        boolean bl = isCollapse = depthDelta == 0;
        if (isCollapse) {
            return 3;
        }
        return 2;
    }

    private boolean isShell(int geomIndex) {
        if (geomIndex == 0) {
            return this.aDim == 2 && !this.aIsHole;
        }
        return this.bDim == 2 && !this.bIsHole;
    }

    private static int locationRight(int depthDelta) {
        int delSign = Edge.delSign(depthDelta);
        switch (delSign) {
            case 0: {
                return OverlayLabel.LOC_UNKNOWN;
            }
            case 1: {
                return 0;
            }
            case -1: {
                return 2;
            }
        }
        return OverlayLabel.LOC_UNKNOWN;
    }

    private static int locationLeft(int depthDelta) {
        int delSign = Edge.delSign(depthDelta);
        switch (delSign) {
            case 0: {
                return OverlayLabel.LOC_UNKNOWN;
            }
            case 1: {
                return 2;
            }
            case -1: {
                return 0;
            }
        }
        return OverlayLabel.LOC_UNKNOWN;
    }

    private static int delSign(int depthDel) {
        if (depthDel > 0) {
            return 1;
        }
        if (depthDel < 0) {
            return -1;
        }
        return 0;
    }

    private void copyInfo(EdgeSourceInfo info) {
        if (info.getIndex() == 0) {
            this.aDim = info.getDimension();
            this.aIsHole = info.isHole();
            this.aDepthDelta = info.getDepthDelta();
        } else {
            this.bDim = info.getDimension();
            this.bIsHole = info.isHole();
            this.bDepthDelta = info.getDepthDelta();
        }
    }

    public void merge(Edge edge) {
        boolean relDir;
        this.aIsHole = Edge.isHoleMerged(0, this, edge);
        this.bIsHole = Edge.isHoleMerged(1, this, edge);
        if (edge.aDim > this.aDim) {
            this.aDim = edge.aDim;
        }
        if (edge.bDim > this.bDim) {
            this.bDim = edge.bDim;
        }
        int flipFactor = (relDir = this.relativeDirection(edge)) ? 1 : -1;
        this.aDepthDelta += flipFactor * edge.aDepthDelta;
        this.bDepthDelta += flipFactor * edge.bDepthDelta;
    }

    private static boolean isHoleMerged(int geomIndex, Edge edge1, Edge edge2) {
        boolean isShell1 = edge1.isShell(geomIndex);
        boolean isShell2 = edge2.isShell(geomIndex);
        boolean isShellMerged = isShell1 || isShell2;
        return !isShellMerged;
    }

    public String toString() {
        String ptsStr = Edge.toStringPts(this.pts);
        String aInfo = Edge.infoString(0, this.aDim, this.aIsHole, this.aDepthDelta);
        String bInfo = Edge.infoString(1, this.bDim, this.bIsHole, this.bDepthDelta);
        return "Edge( " + ptsStr + " ) " + aInfo + "/" + bInfo;
    }

    public String toLineString() {
        return WKTWriter.toLineString(this.pts);
    }

    private static String toStringPts(Coordinate[] pts) {
        Coordinate orig = pts[0];
        Coordinate dest = pts[pts.length - 1];
        String dirPtStr = pts.length > 2 ? ", " + WKTWriter.format(pts[1]) : "";
        String ptsStr = WKTWriter.format(orig) + dirPtStr + " .. " + WKTWriter.format(dest);
        return ptsStr;
    }

    public static String infoString(int index, int dim, boolean isHole, int depthDelta) {
        return (index == 0 ? "A:" : "B:") + OverlayLabel.dimensionSymbol(dim) + Edge.ringRoleSymbol(dim, isHole) + Integer.toString(depthDelta);
    }

    private static String ringRoleSymbol(int dim, boolean isHole) {
        if (Edge.hasAreaParent(dim)) {
            return "" + OverlayLabel.ringRoleSymbol(isHole);
        }
        return "";
    }

    private static boolean hasAreaParent(int dim) {
        return dim == 2 || dim == 3;
    }
}

