/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.distance;

import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.Geometry;
import shadow.org.locationtech.jts.io.WKTWriter;

public class GeometryLocation {
    public static final int INSIDE_AREA = -1;
    private Geometry component = null;
    private int segIndex;
    private Coordinate pt = null;

    public GeometryLocation(Geometry component, int segIndex, Coordinate pt) {
        this.component = component;
        this.segIndex = segIndex;
        this.pt = pt;
    }

    public GeometryLocation(Geometry component, Coordinate pt) {
        this(component, -1, pt);
    }

    public Geometry getGeometryComponent() {
        return this.component;
    }

    public int getSegmentIndex() {
        return this.segIndex;
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public boolean isInsideArea() {
        return this.segIndex == -1;
    }

    public String toString() {
        return this.component.getGeometryType() + "[" + this.segIndex + "]-" + WKTWriter.toPoint(this.pt);
    }
}

