/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.operation.buffer;

import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateArrays;
import shadow.org.locationtech.jts.geom.PrecisionModel;
import shadow.org.locationtech.jts.operation.buffer.BufferInputLineSimplifier;
import shadow.org.locationtech.jts.operation.buffer.BufferParameters;
import shadow.org.locationtech.jts.operation.buffer.OffsetSegmentGenerator;

public class OffsetCurveBuilder {
    private double distance = 0.0;
    private PrecisionModel precisionModel;
    private BufferParameters bufParams;

    public OffsetCurveBuilder(PrecisionModel precisionModel, BufferParameters bufParams) {
        this.precisionModel = precisionModel;
        this.bufParams = bufParams;
    }

    public BufferParameters getBufferParameters() {
        return this.bufParams;
    }

    public Coordinate[] getLineCurve(Coordinate[] inputPts, double distance) {
        this.distance = distance;
        if (this.isLineOffsetEmpty(distance)) {
            return null;
        }
        double posDistance = Math.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else if (this.bufParams.isSingleSided()) {
            boolean isRightSide = distance < 0.0;
            this.computeSingleSidedBufferCurve(inputPts, isRightSide, segGen);
        } else {
            this.computeLineBufferCurve(inputPts, segGen);
        }
        Coordinate[] lineCoord = segGen.getCoordinates();
        return lineCoord;
    }

    public boolean isLineOffsetEmpty(double distance) {
        if (distance == 0.0) {
            return true;
        }
        return distance < 0.0 && !this.bufParams.isSingleSided();
    }

    public Coordinate[] getRingCurve(Coordinate[] inputPts, int side, double distance) {
        this.distance = distance;
        if (inputPts.length <= 2) {
            return this.getLineCurve(inputPts, distance);
        }
        if (distance == 0.0) {
            return OffsetCurveBuilder.copyCoordinates(inputPts);
        }
        OffsetSegmentGenerator segGen = this.getSegGen(distance);
        this.computeRingBufferCurve(inputPts, side, segGen);
        return segGen.getCoordinates();
    }

    public Coordinate[] getOffsetCurve(Coordinate[] inputPts, double distance) {
        this.distance = distance;
        if (distance == 0.0) {
            return null;
        }
        boolean isRightSide = distance < 0.0;
        double posDistance = Math.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else {
            this.computeOffsetCurve(inputPts, isRightSide, segGen);
        }
        Coordinate[] curvePts = segGen.getCoordinates();
        if (isRightSide) {
            CoordinateArrays.reverse(curvePts);
        }
        return curvePts;
    }

    private static Coordinate[] copyCoordinates(Coordinate[] pts) {
        Coordinate[] copy = new Coordinate[pts.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new Coordinate(pts[i]);
        }
        return copy;
    }

    private OffsetSegmentGenerator getSegGen(double distance) {
        return new OffsetSegmentGenerator(this.precisionModel, this.bufParams, distance);
    }

    private double simplifyTolerance(double bufDistance) {
        return bufDistance * this.bufParams.getSimplifyFactor();
    }

    private void computePointCurve(Coordinate pt, OffsetSegmentGenerator segGen) {
        switch (this.bufParams.getEndCapStyle()) {
            case 1: {
                segGen.createCircle(pt);
                break;
            }
            case 3: {
                segGen.createSquare(pt);
            }
        }
    }

    private void computeLineBufferCurve(Coordinate[] inputPts, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        Coordinate[] simp1 = BufferInputLineSimplifier.simplify(inputPts, distTol);
        int n1 = simp1.length - 1;
        segGen.initSideSegments(simp1[0], simp1[1], 1);
        for (int i = 2; i <= n1; ++i) {
            segGen.addNextSegment(simp1[i], true);
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp1[n1 - 1], simp1[n1]);
        Coordinate[] simp2 = BufferInputLineSimplifier.simplify(inputPts, -distTol);
        int n2 = simp2.length - 1;
        segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
        for (int i = n2 - 2; i >= 0; --i) {
            segGen.addNextSegment(simp2[i], true);
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp2[1], simp2[0]);
        segGen.closeRing();
    }

    private void computeSingleSidedBufferCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (isRightSide) {
            segGen.addSegments(inputPts, true);
            Coordinate[] simp2 = BufferInputLineSimplifier.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
            segGen.addFirstSegment();
            for (int i = n2 - 2; i >= 0; --i) {
                segGen.addNextSegment(simp2[i], true);
            }
        } else {
            segGen.addSegments(inputPts, false);
            Coordinate[] simp1 = BufferInputLineSimplifier.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], 1);
            segGen.addFirstSegment();
            for (int i = 2; i <= n1; ++i) {
                segGen.addNextSegment(simp1[i], true);
            }
        }
        segGen.addLastSegment();
        segGen.closeRing();
    }

    private void computeOffsetCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (isRightSide) {
            Coordinate[] simp2 = BufferInputLineSimplifier.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], 1);
            segGen.addFirstSegment();
            for (int i = n2 - 2; i >= 0; --i) {
                segGen.addNextSegment(simp2[i], true);
            }
        } else {
            Coordinate[] simp1 = BufferInputLineSimplifier.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], 1);
            segGen.addFirstSegment();
            for (int i = 2; i <= n1; ++i) {
                segGen.addNextSegment(simp1[i], true);
            }
        }
        segGen.addLastSegment();
    }

    private void computeRingBufferCurve(Coordinate[] inputPts, int side, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance);
        if (side == 2) {
            distTol = -distTol;
        }
        Coordinate[] simp = BufferInputLineSimplifier.simplify(inputPts, distTol);
        int n = simp.length - 1;
        segGen.initSideSegments(simp[n - 1], simp[0], side);
        for (int i = 1; i <= n; ++i) {
            boolean addStartPoint = i != 1;
            segGen.addNextSegment(simp[i], addStartPoint);
        }
        segGen.closeRing();
    }
}

