/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateList;
import shadow.org.locationtech.jts.geom.PrecisionModel;
import shadow.org.locationtech.jts.index.kdtree.KdNode;
import shadow.org.locationtech.jts.index.kdtree.KdNodeVisitor;
import shadow.org.locationtech.jts.noding.MCIndexNoder;
import shadow.org.locationtech.jts.noding.NodedSegmentString;
import shadow.org.locationtech.jts.noding.Noder;
import shadow.org.locationtech.jts.noding.SegmentString;
import shadow.org.locationtech.jts.noding.snapround.HotPixel;
import shadow.org.locationtech.jts.noding.snapround.HotPixelIndex;
import shadow.org.locationtech.jts.noding.snapround.SnapRoundingIntersectionAdder;

public class SnapRoundingNoder
implements Noder {
    private final PrecisionModel pm;
    private final HotPixelIndex pixelIndex;
    private List<NodedSegmentString> snappedResult;

    public SnapRoundingNoder(PrecisionModel pm) {
        this.pm = pm;
        this.pixelIndex = new HotPixelIndex(pm);
    }

    @Override
    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.snappedResult);
    }

    @Override
    public void computeNodes(Collection inputSegmentStrings) {
        this.snappedResult = this.snapRound(inputSegmentStrings);
    }

    private List<NodedSegmentString> snapRound(Collection<NodedSegmentString> segStrings) {
        this.addIntersectionPixels(segStrings);
        this.addVertexPixels(segStrings);
        List<NodedSegmentString> snapped = this.computeSnaps(segStrings);
        return snapped;
    }

    private void addIntersectionPixels(Collection<NodedSegmentString> segStrings) {
        SnapRoundingIntersectionAdder intAdder = new SnapRoundingIntersectionAdder(this.pm);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(intAdder);
        noder.computeNodes(segStrings);
        List<Coordinate> intPts = intAdder.getIntersections();
        this.pixelIndex.addNodes(intPts);
    }

    private void addVertexPixels(Collection<NodedSegmentString> segStrings) {
        for (SegmentString segmentString : segStrings) {
            Coordinate[] pts = segmentString.getCoordinates();
            this.pixelIndex.add(pts);
        }
    }

    private Coordinate round(Coordinate pt) {
        Coordinate p2 = pt.copy();
        this.pm.makePrecise(p2);
        return p2;
    }

    private Coordinate[] round(Coordinate[] pts) {
        CoordinateList roundPts = new CoordinateList();
        for (int i = 0; i < pts.length; ++i) {
            roundPts.add(this.round(pts[i]), false);
        }
        return roundPts.toCoordinateArray();
    }

    private List<NodedSegmentString> computeSnaps(Collection<NodedSegmentString> segStrings) {
        ArrayList<NodedSegmentString> snapped = new ArrayList<NodedSegmentString>();
        for (NodedSegmentString ss : segStrings) {
            NodedSegmentString snappedSS = this.computeSegmentSnaps(ss);
            if (snappedSS == null) continue;
            snapped.add(snappedSS);
        }
        for (NodedSegmentString ss : snapped) {
            this.addVertexNodeSnaps(ss);
        }
        return snapped;
    }

    private NodedSegmentString computeSegmentSnaps(NodedSegmentString ss) {
        Coordinate[] pts = ss.getNodedCoordinates();
        Coordinate[] ptsRound = this.round(pts);
        if (ptsRound.length <= 1) {
            return null;
        }
        NodedSegmentString snapSS = new NodedSegmentString(ptsRound, ss.getData());
        int snapSSindex = 0;
        for (int i = 0; i < pts.length - 1; ++i) {
            Coordinate currSnap = snapSS.getCoordinate(snapSSindex);
            Coordinate p1 = pts[i + 1];
            Coordinate p1Round = this.round(p1);
            if (p1Round.equals2D(currSnap)) continue;
            Coordinate p0 = pts[i];
            this.snapSegment(p0, p1, snapSS, snapSSindex);
            ++snapSSindex;
        }
        return snapSS;
    }

    private void snapSegment(final Coordinate p0, final Coordinate p1, final NodedSegmentString ss, final int segIndex) {
        this.pixelIndex.query(p0, p1, new KdNodeVisitor(){

            @Override
            public void visit(KdNode node) {
                HotPixel hp = (HotPixel)node.getData();
                if (!hp.isNode() && (hp.intersects(p0) || hp.intersects(p1))) {
                    return;
                }
                if (hp.intersects(p0, p1)) {
                    ss.addIntersection(hp.getCoordinate(), segIndex);
                    hp.setToNode();
                }
            }
        });
    }

    private void addVertexNodeSnaps(NodedSegmentString ss) {
        Coordinate[] pts = ss.getCoordinates();
        for (int i = 1; i < pts.length - 1; ++i) {
            Coordinate p0 = pts[i];
            this.snapVertexNode(p0, ss, i);
        }
    }

    private void snapVertexNode(final Coordinate p0, final NodedSegmentString ss, final int segIndex) {
        this.pixelIndex.query(p0, p0, new KdNodeVisitor(){

            @Override
            public void visit(KdNode node) {
                HotPixel hp = (HotPixel)node.getData();
                if (hp.isNode() && hp.getCoordinate().equals2D(p0)) {
                    ss.addIntersection(p0, segIndex);
                }
            }
        });
    }
}

