/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.noding.snap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateList;
import shadow.org.locationtech.jts.noding.MCIndexNoder;
import shadow.org.locationtech.jts.noding.NodedSegmentString;
import shadow.org.locationtech.jts.noding.Noder;
import shadow.org.locationtech.jts.noding.SegmentString;
import shadow.org.locationtech.jts.noding.snap.SnappingIntersectionAdder;
import shadow.org.locationtech.jts.noding.snap.SnappingPointIndex;

public class SnappingNoder
implements Noder {
    private SnappingPointIndex snapIndex;
    private double snapTolerance;
    private List<NodedSegmentString> nodedResult;

    public SnappingNoder(double snapTolerance) {
        this.snapTolerance = snapTolerance;
        this.snapIndex = new SnappingPointIndex(snapTolerance);
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.nodedResult;
    }

    @Override
    public void computeNodes(Collection inputSegStrings) {
        List<NodedSegmentString> snappedSS = this.snapVertices(inputSegStrings);
        this.nodedResult = (List)this.snapIntersections(snappedSS);
    }

    private List<NodedSegmentString> snapVertices(Collection<SegmentString> segStrings) {
        ArrayList<NodedSegmentString> nodedStrings = new ArrayList<NodedSegmentString>();
        for (SegmentString ss : segStrings) {
            nodedStrings.add(this.snapVertices(ss));
        }
        return nodedStrings;
    }

    private NodedSegmentString snapVertices(SegmentString ss) {
        Coordinate[] snapCoords = this.snap(ss.getCoordinates());
        return new NodedSegmentString(snapCoords, ss.getData());
    }

    private Coordinate[] snap(Coordinate[] coords) {
        CoordinateList snapCoords = new CoordinateList();
        for (int i = 0; i < coords.length; ++i) {
            Coordinate pt = this.snapIndex.snap(coords[i]);
            snapCoords.add(pt, false);
        }
        return snapCoords.toCoordinateArray();
    }

    private Collection snapIntersections(List<NodedSegmentString> inputSS) {
        SnappingIntersectionAdder intAdder = new SnappingIntersectionAdder(this.snapTolerance, this.snapIndex);
        MCIndexNoder noder = new MCIndexNoder(intAdder, 2.0 * this.snapTolerance);
        noder.computeNodes(inputSS);
        return noder.getNodedSubstrings();
    }
}

