/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.noding;

import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.impl.CoordinateArraySequence;
import shadow.org.locationtech.jts.io.WKTWriter;
import shadow.org.locationtech.jts.noding.Octant;
import shadow.org.locationtech.jts.noding.SegmentString;

public class BasicSegmentString
implements SegmentString {
    private Coordinate[] pts;
    private Object data;

    public BasicSegmentString(Coordinate[] pts, Object data) {
        this.pts = pts;
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.pts.length;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    @Override
    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public int getSegmentOctant(int index) {
        if (index == this.pts.length - 1) {
            return -1;
        }
        return Octant.octant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

