/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.index.intervalrtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shadow.org.locationtech.jts.index.ItemVisitor;
import shadow.org.locationtech.jts.index.intervalrtree.IntervalRTreeBranchNode;
import shadow.org.locationtech.jts.index.intervalrtree.IntervalRTreeLeafNode;
import shadow.org.locationtech.jts.index.intervalrtree.IntervalRTreeNode;

public class SortedPackedIntervalRTree {
    private final List leaves = new ArrayList();
    private volatile IntervalRTreeNode root = null;

    public void insert(double min, double max, Object item) {
        if (this.root != null) {
            throw new IllegalStateException("Index cannot be added to once it has been queried");
        }
        this.leaves.add(new IntervalRTreeLeafNode(min, max, item));
    }

    private synchronized void init() {
        if (this.root != null) {
            return;
        }
        if (this.leaves.size() == 0) {
            return;
        }
        this.buildRoot();
    }

    private void buildRoot() {
        if (this.root != null) {
            return;
        }
        this.root = this.buildTree();
    }

    private IntervalRTreeNode buildTree() {
        Collections.sort(this.leaves, new IntervalRTreeNode.NodeComparator());
        ArrayList src = this.leaves;
        ArrayList temp = null;
        ArrayList dest = new ArrayList();
        while (true) {
            this.buildLevel(src, dest);
            if (dest.size() == 1) {
                return (IntervalRTreeNode)dest.get(0);
            }
            temp = src;
            src = dest;
            dest = temp;
        }
    }

    private void buildLevel(List src, List dest) {
        dest.clear();
        for (int i = 0; i < src.size(); i += 2) {
            IntervalRTreeNode n2;
            IntervalRTreeNode n1 = (IntervalRTreeNode)src.get(i);
            IntervalRTreeNode intervalRTreeNode = n2 = i + 1 < src.size() ? (IntervalRTreeNode)src.get(i) : null;
            if (n2 == null) {
                dest.add(n1);
                continue;
            }
            IntervalRTreeBranchNode node = new IntervalRTreeBranchNode((IntervalRTreeNode)src.get(i), (IntervalRTreeNode)src.get(i + 1));
            dest.add(node);
        }
    }

    public void query(double min, double max, ItemVisitor visitor) {
        this.init();
        if (this.root == null) {
            return;
        }
        this.root.query(min, max, visitor);
    }
}

