/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.List;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.Quadrant;
import shadow.org.locationtech.jts.util.IntArrayList;

public class MonotoneChainIndexer {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    public int[] getChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        IntArrayList startIndexList = new IntArrayList(pts.length / 2);
        startIndexList.add(start);
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(last);
        } while ((start = last) < pts.length - 1);
        return startIndexList.toArray();
    }

    public int[] OLDgetChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(start);
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(last);
        } while ((start = last) < pts.length - 1);
        int[] startIndex = MonotoneChainIndexer.toIntArray(startIndexList);
        return startIndex;
    }

    private int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last;
        int chainQuad = Quadrant.quadrant(pts[start], pts[start + 1]);
        for (last = start + 1; last < pts.length && (quad = Quadrant.quadrant(pts[last - 1], pts[last])) == chainQuad; ++last) {
        }
        return last - 1;
    }
}

