/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geomgraph.index;

import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.Envelope;
import shadow.org.locationtech.jts.geomgraph.Edge;
import shadow.org.locationtech.jts.geomgraph.index.MonotoneChainIndexer;
import shadow.org.locationtech.jts.geomgraph.index.SegmentIntersector;

public class MonotoneChainEdge {
    Edge e;
    Coordinate[] pts;
    int[] startIndex;

    public MonotoneChainEdge(Edge e) {
        this.e = e;
        this.pts = e.getCoordinates();
        MonotoneChainIndexer mcb = new MonotoneChainIndexer();
        this.startIndex = mcb.getChainStartIndices(this.pts);
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public int[] getStartIndexes() {
        return this.startIndex;
    }

    public double getMinX(int chainIndex) {
        double x1 = this.pts[this.startIndex[chainIndex]].x;
        double x2 = this.pts[this.startIndex[chainIndex + 1]].x;
        return x1 < x2 ? x1 : x2;
    }

    public double getMaxX(int chainIndex) {
        double x1 = this.pts[this.startIndex[chainIndex]].x;
        double x2 = this.pts[this.startIndex[chainIndex + 1]].x;
        return x1 > x2 ? x1 : x2;
    }

    public void computeIntersects(MonotoneChainEdge mce, SegmentIntersector si) {
        for (int i = 0; i < this.startIndex.length - 1; ++i) {
            for (int j = 0; j < mce.startIndex.length - 1; ++j) {
                this.computeIntersectsForChain(i, mce, j, si);
            }
        }
    }

    public void computeIntersectsForChain(int chainIndex0, MonotoneChainEdge mce, int chainIndex1, SegmentIntersector si) {
        this.computeIntersectsForChain(this.startIndex[chainIndex0], this.startIndex[chainIndex0 + 1], mce, mce.startIndex[chainIndex1], mce.startIndex[chainIndex1 + 1], si);
    }

    private void computeIntersectsForChain(int start0, int end0, MonotoneChainEdge mce, int start1, int end1, SegmentIntersector ei) {
        if (end0 - start0 == 1 && end1 - start1 == 1) {
            ei.addIntersections(this.e, start0, mce.e, start1);
            return;
        }
        if (!this.overlaps(start0, end0, mce, start1, end1)) {
            return;
        }
        int mid0 = (start0 + end0) / 2;
        int mid1 = (start1 + end1) / 2;
        if (start0 < mid0) {
            if (start1 < mid1) {
                this.computeIntersectsForChain(start0, mid0, mce, start1, mid1, ei);
            }
            if (mid1 < end1) {
                this.computeIntersectsForChain(start0, mid0, mce, mid1, end1, ei);
            }
        }
        if (mid0 < end0) {
            if (start1 < mid1) {
                this.computeIntersectsForChain(mid0, end0, mce, start1, mid1, ei);
            }
            if (mid1 < end1) {
                this.computeIntersectsForChain(mid0, end0, mce, mid1, end1, ei);
            }
        }
    }

    private boolean overlaps(int start0, int end0, MonotoneChainEdge mce, int start1, int end1) {
        return Envelope.intersects(this.pts[start0], this.pts[end0], mce.pts[start1], mce.pts[end1]);
    }
}

