/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geomgraph.Edge;
import shadow.org.locationtech.jts.noding.OrientedCoordinateArray;

public class EdgeList {
    private List edges = new ArrayList();
    private Map ocaMap = new TreeMap();

    public void add(Edge e) {
        this.edges.add(e);
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        this.ocaMap.put(oca, e);
    }

    public void addAll(Collection edgeColl) {
        Iterator i = edgeColl.iterator();
        while (i.hasNext()) {
            this.add((Edge)i.next());
        }
    }

    public List getEdges() {
        return this.edges;
    }

    public Edge findEqualEdge(Edge e) {
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        Edge matchEdge = (Edge)this.ocaMap.get(oca);
        return matchEdge;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public Edge get(int i) {
        return (Edge)this.edges.get(i);
    }

    public int findEdgeIndex(Edge e) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if (!((Edge)this.edges.get(i)).equals(e)) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream out) {
        out.print("MULTILINESTRING ( ");
        for (int j = 0; j < this.edges.size(); ++j) {
            Edge e = (Edge)this.edges.get(j);
            if (j > 0) {
                out.print(",");
            }
            out.print("(");
            Coordinate[] pts = e.getCoordinates();
            for (int i = 0; i < pts.length; ++i) {
                if (i > 0) {
                    out.print(",");
                }
                out.print(pts[i].x + " " + pts[i].y);
            }
            out.println(")");
        }
        out.print(")  ");
    }
}

