/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import shadow.org.locationtech.jts.geom.Geometry;

public class GeometryMapper {
    public static Geometry map(Geometry geom, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry g = op.map(geom.getGeometryN(i));
            if (g == null) continue;
            mapped.add(g);
        }
        return geom.getFactory().buildGeometry(mapped);
    }

    public static Collection map(Collection geoms, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (Geometry g : geoms) {
            Geometry gr = op.map(g);
            if (gr == null) continue;
            mapped.add(gr);
        }
        return mapped;
    }

    public static interface MapOp {
        public Geometry map(Geometry var1);
    }
}

