/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geom.util;

import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateSequence;
import shadow.org.locationtech.jts.geom.CoordinateSequenceFilter;
import shadow.org.locationtech.jts.geom.Geometry;
import shadow.org.locationtech.jts.geom.util.NoninvertibleTransformationException;
import shadow.org.locationtech.jts.util.Assert;

public class AffineTransformation
implements Cloneable,
CoordinateSequenceFilter {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public static AffineTransformation reflectionInstance(double x0, double y0, double x1, double y1) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToReflection(x0, y0, x1, y1);
        return trans;
    }

    public static AffineTransformation reflectionInstance(double x, double y) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToReflection(x, y);
        return trans;
    }

    public static AffineTransformation rotationInstance(double theta) {
        return AffineTransformation.rotationInstance(Math.sin(theta), Math.cos(theta));
    }

    public static AffineTransformation rotationInstance(double sinTheta, double cosTheta) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToRotation(sinTheta, cosTheta);
        return trans;
    }

    public static AffineTransformation rotationInstance(double theta, double x, double y) {
        return AffineTransformation.rotationInstance(Math.sin(theta), Math.cos(theta), x, y);
    }

    public static AffineTransformation rotationInstance(double sinTheta, double cosTheta, double x, double y) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToRotation(sinTheta, cosTheta, x, y);
        return trans;
    }

    public static AffineTransformation scaleInstance(double xScale, double yScale) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToScale(xScale, yScale);
        return trans;
    }

    public static AffineTransformation scaleInstance(double xScale, double yScale, double x, double y) {
        AffineTransformation trans = new AffineTransformation();
        trans.translate(-x, -y);
        trans.scale(xScale, yScale);
        trans.translate(x, y);
        return trans;
    }

    public static AffineTransformation shearInstance(double xShear, double yShear) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToShear(xShear, yShear);
        return trans;
    }

    public static AffineTransformation translationInstance(double x, double y) {
        AffineTransformation trans = new AffineTransformation();
        trans.setToTranslation(x, y);
        return trans;
    }

    public AffineTransformation() {
        this.setToIdentity();
    }

    public AffineTransformation(double[] matrix) {
        this.m00 = matrix[0];
        this.m01 = matrix[1];
        this.m02 = matrix[2];
        this.m10 = matrix[3];
        this.m11 = matrix[4];
        this.m12 = matrix[5];
    }

    public AffineTransformation(double m00, double m01, double m02, double m10, double m11, double m12) {
        this.setTransformation(m00, m01, m02, m10, m11, m12);
    }

    public AffineTransformation(AffineTransformation trans) {
        this.setTransformation(trans);
    }

    public AffineTransformation(Coordinate src0, Coordinate src1, Coordinate src2, Coordinate dest0, Coordinate dest1, Coordinate dest2) {
    }

    public AffineTransformation setToIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setTransformation(double m00, double m01, double m02, double m10, double m11, double m12) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        return this;
    }

    public AffineTransformation setTransformation(AffineTransformation trans) {
        this.m00 = trans.m00;
        this.m01 = trans.m01;
        this.m02 = trans.m02;
        this.m10 = trans.m10;
        this.m11 = trans.m11;
        this.m12 = trans.m12;
        return this;
    }

    public double[] getMatrixEntries() {
        return new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public AffineTransformation getInverse() throws NoninvertibleTransformationException {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformationException("Transformation is non-invertible");
        }
        double im00 = this.m11 / det;
        double im10 = -this.m10 / det;
        double im01 = -this.m01 / det;
        double im11 = this.m00 / det;
        double im02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        double im12 = (-this.m00 * this.m12 + this.m10 * this.m02) / det;
        return new AffineTransformation(im00, im01, im02, im10, im11, im12);
    }

    public AffineTransformation setToReflectionBasic(double x0, double y0, double x1, double y1) {
        double c2s2;
        if (x0 == x1 && y0 == y1) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d = Math.sqrt(dx * dx + dy * dy);
        double sin = dy / d;
        double cos = dx / d;
        double cs2 = 2.0 * sin * cos;
        this.m00 = c2s2 = cos * cos - sin * sin;
        this.m01 = cs2;
        this.m02 = 0.0;
        this.m10 = cs2;
        this.m11 = -c2s2;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToReflection(double x0, double y0, double x1, double y1) {
        if (x0 == x1 && y0 == y1) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        this.setToTranslation(-x0, -y0);
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d = Math.sqrt(dx * dx + dy * dy);
        double sin = dy / d;
        double cos = dx / d;
        this.rotate(-sin, cos);
        this.scale(1.0, -1.0);
        this.rotate(sin, cos);
        this.translate(x0, y0);
        return this;
    }

    public AffineTransformation setToReflection(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            throw new IllegalArgumentException("Reflection vector must be non-zero");
        }
        if (x == y) {
            this.m00 = 0.0;
            this.m01 = 1.0;
            this.m02 = 0.0;
            this.m10 = 1.0;
            this.m11 = 0.0;
            this.m12 = 0.0;
            return this;
        }
        double d = Math.sqrt(x * x + y * y);
        double sin = y / d;
        double cos = x / d;
        this.rotate(-sin, cos);
        this.scale(1.0, -1.0);
        this.rotate(sin, cos);
        return this;
    }

    public AffineTransformation setToRotation(double theta) {
        this.setToRotation(Math.sin(theta), Math.cos(theta));
        return this;
    }

    public AffineTransformation setToRotation(double sinTheta, double cosTheta) {
        this.m00 = cosTheta;
        this.m01 = -sinTheta;
        this.m02 = 0.0;
        this.m10 = sinTheta;
        this.m11 = cosTheta;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToRotation(double theta, double x, double y) {
        this.setToRotation(Math.sin(theta), Math.cos(theta), x, y);
        return this;
    }

    public AffineTransformation setToRotation(double sinTheta, double cosTheta, double x, double y) {
        this.m00 = cosTheta;
        this.m01 = -sinTheta;
        this.m02 = x - x * cosTheta + y * sinTheta;
        this.m10 = sinTheta;
        this.m11 = cosTheta;
        this.m12 = y - x * sinTheta - y * cosTheta;
        return this;
    }

    public AffineTransformation setToScale(double xScale, double yScale) {
        this.m00 = xScale;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = yScale;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToShear(double xShear, double yShear) {
        this.m00 = 1.0;
        this.m01 = xShear;
        this.m02 = 0.0;
        this.m10 = yShear;
        this.m11 = 1.0;
        this.m12 = 0.0;
        return this;
    }

    public AffineTransformation setToTranslation(double dx, double dy) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = dx;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = dy;
        return this;
    }

    public AffineTransformation reflect(double x0, double y0, double x1, double y1) {
        this.compose(AffineTransformation.reflectionInstance(x0, y0, x1, y1));
        return this;
    }

    public AffineTransformation reflect(double x, double y) {
        this.compose(AffineTransformation.reflectionInstance(x, y));
        return this;
    }

    public AffineTransformation rotate(double theta) {
        this.compose(AffineTransformation.rotationInstance(theta));
        return this;
    }

    public AffineTransformation rotate(double sinTheta, double cosTheta) {
        this.compose(AffineTransformation.rotationInstance(sinTheta, cosTheta));
        return this;
    }

    public AffineTransformation rotate(double theta, double x, double y) {
        this.compose(AffineTransformation.rotationInstance(theta, x, y));
        return this;
    }

    public AffineTransformation rotate(double sinTheta, double cosTheta, double x, double y) {
        this.compose(AffineTransformation.rotationInstance(sinTheta, cosTheta, x, y));
        return this;
    }

    public AffineTransformation scale(double xScale, double yScale) {
        this.compose(AffineTransformation.scaleInstance(xScale, yScale));
        return this;
    }

    public AffineTransformation shear(double xShear, double yShear) {
        this.compose(AffineTransformation.shearInstance(xShear, yShear));
        return this;
    }

    public AffineTransformation translate(double x, double y) {
        this.compose(AffineTransformation.translationInstance(x, y));
        return this;
    }

    public AffineTransformation compose(AffineTransformation trans) {
        double mp00 = trans.m00 * this.m00 + trans.m01 * this.m10;
        double mp01 = trans.m00 * this.m01 + trans.m01 * this.m11;
        double mp02 = trans.m00 * this.m02 + trans.m01 * this.m12 + trans.m02;
        double mp10 = trans.m10 * this.m00 + trans.m11 * this.m10;
        double mp11 = trans.m10 * this.m01 + trans.m11 * this.m11;
        double mp12 = trans.m10 * this.m02 + trans.m11 * this.m12 + trans.m12;
        this.m00 = mp00;
        this.m01 = mp01;
        this.m02 = mp02;
        this.m10 = mp10;
        this.m11 = mp11;
        this.m12 = mp12;
        return this;
    }

    public AffineTransformation composeBefore(AffineTransformation trans) {
        double mp00 = this.m00 * trans.m00 + this.m01 * trans.m10;
        double mp01 = this.m00 * trans.m01 + this.m01 * trans.m11;
        double mp02 = this.m00 * trans.m02 + this.m01 * trans.m12 + this.m02;
        double mp10 = this.m10 * trans.m00 + this.m11 * trans.m10;
        double mp11 = this.m10 * trans.m01 + this.m11 * trans.m11;
        double mp12 = this.m10 * trans.m02 + this.m11 * trans.m12 + this.m12;
        this.m00 = mp00;
        this.m01 = mp01;
        this.m02 = mp02;
        this.m10 = mp10;
        this.m11 = mp11;
        this.m12 = mp12;
        return this;
    }

    public Coordinate transform(Coordinate src, Coordinate dest) {
        double xp = this.m00 * src.x + this.m01 * src.y + this.m02;
        double yp = this.m10 * src.x + this.m11 * src.y + this.m12;
        dest.x = xp;
        dest.y = yp;
        return dest;
    }

    public Geometry transform(Geometry g) {
        Geometry g2 = g.copy();
        g2.apply(this);
        return g2;
    }

    public void transform(CoordinateSequence seq, int i) {
        double xp = this.m00 * seq.getOrdinate(i, 0) + this.m01 * seq.getOrdinate(i, 1) + this.m02;
        double yp = this.m10 * seq.getOrdinate(i, 0) + this.m11 * seq.getOrdinate(i, 1) + this.m12;
        seq.setOrdinate(i, 0, xp);
        seq.setOrdinate(i, 1, yp);
    }

    @Override
    public void filter(CoordinateSequence seq, int i) {
        this.transform(seq, i);
    }

    @Override
    public boolean isGeometryChanged() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AffineTransformation)) {
            return false;
        }
        AffineTransformation trans = (AffineTransformation)obj;
        return this.m00 == trans.m00 && this.m01 == trans.m01 && this.m02 == trans.m02 && this.m10 == trans.m10 && this.m11 == trans.m11 && this.m12 == trans.m12;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m02);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m12);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "AffineTransformation[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }
}

