/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geom.impl;

import java.io.Serializable;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.CoordinateSequence;
import shadow.org.locationtech.jts.geom.CoordinateSequenceFactory;
import shadow.org.locationtech.jts.geom.impl.CoordinateArraySequence;

public final class CoordinateArraySequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    private static final long serialVersionUID = -4099577099607551657L;
    private static final CoordinateArraySequenceFactory instanceObject = new CoordinateArraySequenceFactory();

    private CoordinateArraySequenceFactory() {
    }

    private Object readResolve() {
        return CoordinateArraySequenceFactory.instance();
    }

    public static CoordinateArraySequenceFactory instance() {
        return instanceObject;
    }

    @Override
    public CoordinateSequence create(Coordinate[] coordinates) {
        return new CoordinateArraySequence(coordinates);
    }

    @Override
    public CoordinateSequence create(CoordinateSequence coordSeq) {
        return new CoordinateArraySequence(coordSeq);
    }

    @Override
    public CoordinateSequence create(int size, int dimension) {
        if (dimension > 3) {
            dimension = 3;
        }
        if (dimension < 2) {
            dimension = 2;
        }
        return new CoordinateArraySequence(size, dimension);
    }

    @Override
    public CoordinateSequence create(int size, int dimension, int measures) {
        int spatial = dimension - measures;
        if (measures > 1) {
            measures = 1;
        }
        if (spatial > 3) {
            spatial = 3;
        }
        if (spatial < 2) {
            spatial = 2;
        }
        return new CoordinateArraySequence(size, spatial + measures, measures);
    }
}

