/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import shadow.org.locationtech.jts.geom.Coordinate;

public class CoordinateList
extends ArrayList<Coordinate> {
    private static final long serialVersionUID = -1626110935756089896L;
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public CoordinateList() {
    }

    public CoordinateList(Coordinate[] coord) {
        this.ensureCapacity(coord.length);
        this.add(coord, true);
    }

    public CoordinateList(Coordinate[] coord, boolean allowRepeated) {
        this.ensureCapacity(coord.length);
        this.add(coord, allowRepeated);
    }

    public Coordinate getCoordinate(int i) {
        return (Coordinate)this.get(i);
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, int start, int end) {
        int inc = 1;
        if (start > end) {
            inc = -1;
        }
        for (int i = start; i != end; i += inc) {
            this.add(coord[i], allowRepeated);
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, boolean direction) {
        if (direction) {
            for (int i = 0; i < coord.length; ++i) {
                this.add(coord[i], allowRepeated);
            }
        } else {
            for (int i = coord.length - 1; i >= 0; --i) {
                this.add(coord[i], allowRepeated);
            }
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated, true);
        return true;
    }

    public boolean add(Object obj, boolean allowRepeated) {
        this.add((Coordinate)obj, allowRepeated);
        return true;
    }

    public void add(Coordinate coord, boolean allowRepeated) {
        Coordinate last;
        if (!allowRepeated && this.size() >= 1 && (last = (Coordinate)this.get(this.size() - 1)).equals2D(coord)) {
            return;
        }
        super.add(coord);
    }

    public void add(int i, Coordinate coord, boolean allowRepeated) {
        int size;
        if (!allowRepeated && (size = this.size()) > 0) {
            Coordinate next;
            Coordinate prev;
            if (i > 0 && (prev = (Coordinate)this.get(i - 1)).equals2D(coord)) {
                return;
            }
            if (i < size && (next = (Coordinate)this.get(i)).equals2D(coord)) {
                return;
            }
        }
        super.add(i, coord);
    }

    public boolean addAll(Collection<? extends Coordinate> coll, boolean allowRepeated) {
        boolean isChanged = false;
        Iterator<? extends Coordinate> i = coll.iterator();
        while (i.hasNext()) {
            this.add(i.next(), allowRepeated);
            isChanged = true;
        }
        return isChanged;
    }

    public void closeRing() {
        if (this.size() > 0) {
            Coordinate duplicate = ((Coordinate)this.get(0)).copy();
            this.add(duplicate, false);
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.toArray(coordArrayType);
    }

    public Coordinate[] toCoordinateArray(boolean isForward) {
        if (isForward) {
            return this.toArray(coordArrayType);
        }
        int size = this.size();
        Coordinate[] pts = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            pts[i] = (Coordinate)this.get(size - i - 1);
        }
        return pts;
    }

    @Override
    public Object clone() {
        CoordinateList clone = (CoordinateList)super.clone();
        for (int i = 0; i < this.size(); ++i) {
            clone.add(i, (Coordinate)((Coordinate)this.get(i)).clone());
        }
        return clone;
    }
}

