/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.algorithm;

import shadow.org.locationtech.jts.algorithm.InteriorPointArea;
import shadow.org.locationtech.jts.algorithm.InteriorPointLine;
import shadow.org.locationtech.jts.algorithm.InteriorPointPoint;
import shadow.org.locationtech.jts.geom.Coordinate;
import shadow.org.locationtech.jts.geom.Geometry;
import shadow.org.locationtech.jts.geom.GeometryCollection;
import shadow.org.locationtech.jts.geom.GeometryFilter;

public class InteriorPoint {
    public static Coordinate getInteriorPoint(Geometry geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate interiorPt = null;
        int dim = InteriorPoint.effectiveDimension(geom);
        if (dim < 0) {
            return null;
        }
        interiorPt = dim == 0 ? InteriorPointPoint.getInteriorPoint(geom) : (dim == 1 ? InteriorPointLine.getInteriorPoint(geom) : InteriorPointArea.getInteriorPoint(geom));
        return interiorPt;
    }

    private static int effectiveDimension(Geometry geom) {
        EffectiveDimensionFilter dimFilter = new EffectiveDimensionFilter();
        geom.apply(dimFilter);
        return dimFilter.getDimension();
    }

    private static class EffectiveDimensionFilter
    implements GeometryFilter {
        private int dim = -1;

        private EffectiveDimensionFilter() {
        }

        public int getDimension() {
            return this.dim;
        }

        @Override
        public void filter(Geometry elem) {
            int elemDim;
            if (elem instanceof GeometryCollection) {
                return;
            }
            if (!elem.isEmpty() && (elemDim = elem.getDimension()) > this.dim) {
                this.dim = elemDim;
            }
        }
    }
}

