/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.locationtech.jts.algorithm;

import shadow.org.locationtech.jts.algorithm.NotRepresentableException;
import shadow.org.locationtech.jts.geom.Coordinate;

public class HCoordinate {
    public double x;
    public double y;
    public double w;

    public static Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) throws NotRepresentableException {
        double px = p1.y - p2.y;
        double py = p2.x - p1.x;
        double pw = p1.x * p2.y - p2.x * p1.y;
        double qx = q1.y - q2.y;
        double qy = q2.x - q1.x;
        double qw = q1.x * q2.y - q2.x * q1.y;
        double x = py * qw - qy * pw;
        double y = qx * pw - px * qw;
        double w = px * qy - qx * py;
        double xInt = x / w;
        double yInt = y / w;
        if (Double.isNaN(xInt) || Double.isInfinite(xInt) || Double.isNaN(yInt) || Double.isInfinite(yInt)) {
            throw new NotRepresentableException();
        }
        return new Coordinate(xInt, yInt);
    }

    public HCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.w = 1.0;
    }

    public HCoordinate(double _x, double _y, double _w) {
        this.x = _x;
        this.y = _y;
        this.w = _w;
    }

    public HCoordinate(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.w = 1.0;
    }

    public HCoordinate(Coordinate p) {
        this.x = p.x;
        this.y = p.y;
        this.w = 1.0;
    }

    public HCoordinate(HCoordinate p1, HCoordinate p2) {
        this.x = p1.y * p2.w - p2.y * p1.w;
        this.y = p2.x * p1.w - p1.x * p2.w;
        this.w = p1.x * p2.y - p2.x * p1.y;
    }

    public HCoordinate(Coordinate p1, Coordinate p2) {
        this.x = p1.y - p2.y;
        this.y = p2.x - p1.x;
        this.w = p1.x * p2.y - p2.x * p1.y;
    }

    public HCoordinate(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        double px = p1.y - p2.y;
        double py = p2.x - p1.x;
        double pw = p1.x * p2.y - p2.x * p1.y;
        double qx = q1.y - q2.y;
        double qy = q2.x - q1.x;
        double qw = q1.x * q2.y - q2.x * q1.y;
        this.x = py * qw - qy * pw;
        this.y = qx * pw - px * qw;
        this.w = px * qy - qx * py;
    }

    public double getX() throws NotRepresentableException {
        double a = this.x / this.w;
        if (Double.isNaN(a) || Double.isInfinite(a)) {
            throw new NotRepresentableException();
        }
        return a;
    }

    public double getY() throws NotRepresentableException {
        double a = this.y / this.w;
        if (Double.isNaN(a) || Double.isInfinite(a)) {
            throw new NotRepresentableException();
        }
        return a;
    }

    public Coordinate getCoordinate() throws NotRepresentableException {
        Coordinate p = new Coordinate();
        p.x = this.getX();
        p.y = this.getY();
        return p;
    }
}

