/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.xml;

import java.util.Optional;
import shadow.javax.xml.namespace.QName;
import shadow.javax.xml.stream.XMLEventReader;
import shadow.javax.xml.stream.XMLStreamException;
import shadow.javax.xml.stream.events.Attribute;
import shadow.javax.xml.stream.events.StartElement;
import shadow.javax.xml.stream.events.XMLEvent;

public abstract class AbstractStaxBuilder {
    protected abstract String getAcceptableQName();

    protected boolean accept(XMLEvent xmlEvent) {
        return xmlEvent.isStartElement() && xmlEvent.asStartElement().getName().getLocalPart().equals(this.getAcceptableQName());
    }

    public boolean process(XMLEventReader xmlEventReader, XMLEvent xmlEvent) {
        if (this.accept(xmlEvent)) {
            try {
                this.add(xmlEventReader, xmlEvent);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException(e);
            }
            return true;
        }
        return false;
    }

    protected abstract void add(XMLEventReader var1, XMLEvent var2) throws XMLStreamException;

    protected String readSingleElement(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        StringBuilder stringBuilder = new StringBuilder(xmlEvent.asCharacters().getData());
        while (xmlEventReader.peek().isCharacters()) {
            xmlEvent = xmlEventReader.nextEvent();
            stringBuilder.append(xmlEvent.asCharacters().getData());
        }
        return stringBuilder.toString().trim();
    }

    protected Optional<String> readAttribute(StartElement startElement, QName qName) {
        Attribute attribute = startElement.getAttributeByName(qName);
        return Optional.ofNullable(attribute).map(Attribute::getValue);
    }
}

