/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.metadata.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

enum BuiltinConstraint {
    JAVAX_VALIDATION_CONSTRAINTS_ASSERT_FALSE("shadow.javax.validation.constraints.AssertFalse"),
    JAVAX_VALIDATION_CONSTRAINTS_ASSERT_TRUE("shadow.javax.validation.constraints.AssertTrue"),
    JAVAX_VALIDATION_CONSTRAINTS_DECIMAL_MAX("shadow.javax.validation.constraints.DecimalMax"),
    JAVAX_VALIDATION_CONSTRAINTS_DECIMAL_MIN("shadow.javax.validation.constraints.DecimalMin"),
    JAVAX_VALIDATION_CONSTRAINTS_DIGITS("shadow.javax.validation.constraints.Digits"),
    JAVAX_VALIDATION_CONSTRAINTS_EMAIL("shadow.javax.validation.constraints.Email"),
    JAVAX_VALIDATION_CONSTRAINTS_FUTURE("shadow.javax.validation.constraints.Future"),
    JAVAX_VALIDATION_CONSTRAINTS_FUTURE_OR_PRESENT("shadow.javax.validation.constraints.FutureOrPresent"),
    JAVAX_VALIDATION_CONSTRAINTS_MIN("shadow.javax.validation.constraints.Min"),
    JAVAX_VALIDATION_CONSTRAINTS_MAX("shadow.javax.validation.constraints.Max"),
    JAVAX_VALIDATION_CONSTRAINTS_NEGATIVE("shadow.javax.validation.constraints.Negative"),
    JAVAX_VALIDATION_CONSTRAINTS_NEGATIVE_OR_ZERO("shadow.javax.validation.constraints.NegativeOrZero"),
    JAVAX_VALIDATION_CONSTRAINTS_NOT_BLANK("shadow.javax.validation.constraints.NotBlank"),
    JAVAX_VALIDATION_CONSTRAINTS_NOT_EMPTY("shadow.javax.validation.constraints.NotEmpty"),
    JAVAX_VALIDATION_CONSTRAINTS_NOT_NULL("shadow.javax.validation.constraints.NotNull"),
    JAVAX_VALIDATION_CONSTRAINTS_NULL("shadow.javax.validation.constraints.Null"),
    JAVAX_VALIDATION_CONSTRAINTS_PAST("shadow.javax.validation.constraints.Past"),
    JAVAX_VALIDATION_CONSTRAINTS_PAST_OR_PRESENT("shadow.javax.validation.constraints.PastOrPresent"),
    JAVAX_VALIDATION_CONSTRAINTS_PATTERN("shadow.javax.validation.constraints.Pattern"),
    JAVAX_VALIDATION_CONSTRAINTS_POSITIVE("shadow.javax.validation.constraints.Positive"),
    JAVAX_VALIDATION_CONSTRAINTS_POSITIVE_OR_ZERO("shadow.javax.validation.constraints.PositiveOrZero"),
    JAVAX_VALIDATION_CONSTRAINTS_SIZE("shadow.javax.validation.constraints.Size"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_CODE_POINT_LENGTH("shadow.org.hibernate.validator.constraints.CodePointLength"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_CURRENCY("shadow.org.hibernate.validator.constraints.Currency"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_EMAIL("shadow.org.hibernate.validator.constraints.Email", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_ISBN("shadow.org.hibernate.validator.constraints.ISBN"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_LENGTH("shadow.org.hibernate.validator.constraints.Length"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_LUHN_CHECK("shadow.org.hibernate.validator.constraints.LuhnCheck"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_CREDIT_CARD_NUMBER("shadow.org.hibernate.validator.constraints.CreditCardNumber", Arrays.asList(ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_LUHN_CHECK)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD10_CHECK("shadow.org.hibernate.validator.constraints.Mod10Check"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD11_CHECK("shadow.org.hibernate.validator.constraints.Mod11Check"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD_CHECK("shadow.org.hibernate.validator.constraints.ModCheck"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_NORMALIZED("shadow.org.hibernate.validator.constraints.Normalized"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_EAN("shadow.org.hibernate.validator.constraints.EAN", Arrays.asList(ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD10_CHECK)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_NOT_BLANK("shadow.org.hibernate.validator.constraints.NotBlank", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_NOT_NULL)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_NOT_EMPTY("shadow.org.hibernate.validator.constraints.NotEmpty", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_NOT_NULL, JAVAX_VALIDATION_CONSTRAINTS_SIZE)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PARAMETER_SCRIPT_ASSERT("shadow.org.hibernate.validator.constraints.ParameterScriptAssert"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_RANGE("shadow.org.hibernate.validator.constraints.Range", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_MIN, JAVAX_VALIDATION_CONSTRAINTS_MAX)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_SAFE_HTML("shadow.org.hibernate.validator.constraints.SafeHtml"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_SCRIPT_ASSERT("shadow.org.hibernate.validator.constraints.ScriptAssert"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_URL("shadow.org.hibernate.validator.constraints.URL", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_UNIQUE_ELEMENTS("shadow.org.hibernate.validator.constraints.UniqueElements"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_BR_CNPJ("shadow.org.hibernate.validator.constraints.br.CNPJ", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_BR_CPF("shadow.org.hibernate.validator.constraints.br.CPF", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_BR_TITULO_ELEITORAL("shadow.org.hibernate.validator.constraints.br.TituloEleitoral", Arrays.asList(JAVAX_VALIDATION_CONSTRAINTS_PATTERN, ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD11_CHECK)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PL_NIP("shadow.org.hibernate.validator.constraints.pl.NIP"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PL_PESEL("shadow.org.hibernate.validator.constraints.pl.PESEL"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PL_REGON("shadow.org.hibernate.validator.constraints.pl.REGON"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_TIME_DURATION_MAX("shadow.org.hibernate.validator.constraints.time.DurationMax"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_TIME_DURATION_MIN("shadow.org.hibernate.validator.constraints.time.DurationMin");

    private static final Map<String, Set<BuiltinConstraint>> CONSTRAINT_MAPPING;
    private String annotationClassName;
    private List<BuiltinConstraint> constraintDependencies;

    private BuiltinConstraint(String constraint) {
        this(constraint, Collections.emptyList());
    }

    private BuiltinConstraint(String constraint, List<BuiltinConstraint> composingConstraints) {
        this.annotationClassName = constraint;
        this.constraintDependencies = composingConstraints;
    }

    static Set<BuiltinConstraint> resolve(Set<String> constraints) {
        HashSet<BuiltinConstraint> resolvedConstraints = new HashSet<BuiltinConstraint>();
        for (String constraint : constraints) {
            Set<BuiltinConstraint> builtinConstraints = CONSTRAINT_MAPPING.get(constraint);
            if (builtinConstraints == null) continue;
            resolvedConstraints.addAll(builtinConstraints);
        }
        return resolvedConstraints;
    }

    static boolean isBuiltin(String constraint) {
        return CONSTRAINT_MAPPING.containsKey(constraint);
    }

    static Set<String> set() {
        return CONSTRAINT_MAPPING.keySet();
    }

    static {
        CONSTRAINT_MAPPING = new HashMap<String, Set<BuiltinConstraint>>();
        for (BuiltinConstraint constraint : BuiltinConstraint.values()) {
            if (constraint.constraintDependencies.isEmpty()) {
                CONSTRAINT_MAPPING.put(constraint.annotationClassName, Collections.singleton(constraint));
                continue;
            }
            HashSet<BuiltinConstraint> constraints = new HashSet<BuiltinConstraint>();
            constraints.add(constraint);
            constraints.addAll(constraint.constraintDependencies);
            CONSTRAINT_MAPPING.put(constraint.annotationClassName, constraints);
        }
    }
}

