/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.metadata;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import shadow.org.hibernate.validator.internal.engine.ConstraintCreationContext;
import shadow.org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import shadow.org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import shadow.org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import shadow.org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import shadow.org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataBuilder;
import shadow.org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import shadow.org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import shadow.org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import shadow.org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider;
import shadow.org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import shadow.org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import shadow.org.hibernate.validator.internal.properties.javabean.JavaBeanHelper;
import shadow.org.hibernate.validator.internal.util.CollectionHelper;
import shadow.org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import shadow.org.hibernate.validator.internal.util.Contracts;
import shadow.org.hibernate.validator.internal.util.ExecutableHelper;
import shadow.org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import shadow.org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import shadow.org.hibernate.validator.internal.util.classhierarchy.Filter;
import shadow.org.hibernate.validator.internal.util.logging.Messages;
import shadow.org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;

public class BeanMetaDataManagerImpl
implements BeanMetaDataManager {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final List<MetaDataProvider> metaDataProviders;
    private final ConstraintCreationContext constraintCreationContext;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final ConcurrentReferenceHashMap<Class<?>, BeanMetaData<?>> beanMetaDataCache;
    private final ExecutableHelper executableHelper;
    private final BeanMetaDataClassNormalizer beanMetaDataClassNormalizer;
    private final ValidationOrderGenerator validationOrderGenerator;
    private final MethodValidationConfiguration methodValidationConfiguration;

    public BeanMetaDataManagerImpl(ConstraintCreationContext constraintCreationContext, ExecutableHelper executableHelper, ExecutableParameterNameProvider parameterNameProvider, JavaBeanHelper javaBeanHelper, BeanMetaDataClassNormalizer beanMetaDataClassNormalizer, ValidationOrderGenerator validationOrderGenerator, List<MetaDataProvider> optionalMetaDataProviders, MethodValidationConfiguration methodValidationConfiguration) {
        this.constraintCreationContext = constraintCreationContext;
        this.executableHelper = executableHelper;
        this.parameterNameProvider = parameterNameProvider;
        this.beanMetaDataClassNormalizer = beanMetaDataClassNormalizer;
        this.validationOrderGenerator = validationOrderGenerator;
        this.methodValidationConfiguration = methodValidationConfiguration;
        this.beanMetaDataCache = new ConcurrentReferenceHashMap(16, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
        AnnotationProcessingOptions annotationProcessingOptions = this.getAnnotationProcessingOptionsFromNonDefaultProviders(optionalMetaDataProviders);
        AnnotationMetaDataProvider defaultProvider = new AnnotationMetaDataProvider(constraintCreationContext, javaBeanHelper, annotationProcessingOptions);
        ArrayList<MetaDataProvider> tmpMetaDataProviders = new ArrayList<MetaDataProvider>(optionalMetaDataProviders.size() + 1);
        tmpMetaDataProviders.add(defaultProvider);
        tmpMetaDataProviders.addAll(optionalMetaDataProviders);
        this.metaDataProviders = CollectionHelper.toImmutableList(tmpMetaDataProviders);
    }

    @Override
    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        Contracts.assertNotNull(beanClass, Messages.MESSAGES.beanTypeCannotBeNull());
        Class<T> normalizedBeanClass = this.beanMetaDataClassNormalizer.normalize(beanClass);
        BeanMetaData<?> beanMetaData = this.beanMetaDataCache.get(normalizedBeanClass);
        if (beanMetaData != null) {
            return beanMetaData;
        }
        beanMetaData = this.createBeanMetaData(normalizedBeanClass);
        BeanMetaData<?> previousBeanMetaData = this.beanMetaDataCache.putIfAbsent(normalizedBeanClass, beanMetaData);
        if (previousBeanMetaData != null) {
            return previousBeanMetaData;
        }
        return beanMetaData;
    }

    @Override
    public void clear() {
        this.beanMetaDataCache.clear();
    }

    public int numberOfCachedBeanMetaDataInstances() {
        return this.beanMetaDataCache.size();
    }

    private <T> BeanMetaDataImpl<T> createBeanMetaData(Class<T> clazz) {
        BeanMetaDataBuilder<T> builder = BeanMetaDataBuilder.getInstance(this.constraintCreationContext, this.executableHelper, this.parameterNameProvider, this.validationOrderGenerator, clazz, this.methodValidationConfiguration);
        for (MetaDataProvider provider : this.metaDataProviders) {
            for (BeanConfiguration<T> beanConfiguration : this.getBeanConfigurationForHierarchy(provider, clazz)) {
                builder.add(beanConfiguration);
            }
        }
        return builder.build();
    }

    private AnnotationProcessingOptions getAnnotationProcessingOptionsFromNonDefaultProviders(List<MetaDataProvider> optionalMetaDataProviders) {
        AnnotationProcessingOptionsImpl options = new AnnotationProcessingOptionsImpl();
        for (MetaDataProvider metaDataProvider : optionalMetaDataProviders) {
            options.merge(metaDataProvider.getAnnotationProcessingOptions());
        }
        return options;
    }

    private <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(MetaDataProvider provider, Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<T> clazz : ClassHierarchyHelper.getHierarchy(beanClass, new Filter[0])) {
            BeanConfiguration<T> configuration = provider.getBeanConfiguration(clazz);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }
}

