/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.engine.valueextraction;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.javax.validation.ValidationException;
import shadow.javax.validation.valueextraction.ValueExtractor;
import shadow.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import shadow.org.hibernate.validator.internal.util.logging.Log;
import shadow.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValueExtractorHelper {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private ValueExtractorHelper() {
    }

    public static Set<Class<? extends ValueExtractor>> toValueExtractorClasses(Set<ValueExtractorDescriptor> valueExtractorDescriptors) {
        return valueExtractorDescriptors.stream().map(valueExtractorDescriptor -> valueExtractorDescriptor.getValueExtractor().getClass()).collect(Collectors.toSet());
    }

    public static void extractValues(ValueExtractorDescriptor valueExtractorDescriptor, Object containerValue, ValueExtractor.ValueReceiver valueReceiver) {
        ValueExtractor<?> valueExtractor = valueExtractorDescriptor.getValueExtractor();
        try {
            valueExtractor.extractValues(containerValue, valueReceiver);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw LOG.getErrorWhileExtractingValuesInValueExtractorException(valueExtractor.getClass(), e);
        }
    }
}

