/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.Collection;
import shadow.javax.validation.ConstraintValidator;
import shadow.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintTree;
import shadow.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import shadow.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import shadow.org.hibernate.validator.internal.engine.validationcontext.ValidationContext;
import shadow.org.hibernate.validator.internal.engine.valuecontext.ValueContext;
import shadow.org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import shadow.org.hibernate.validator.internal.util.logging.Log;
import shadow.org.hibernate.validator.internal.util.logging.LoggerFactory;

class SimpleConstraintTree<B extends Annotation>
extends ConstraintTree<B> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    public SimpleConstraintTree(ConstraintValidatorManager constraintValidatorManager, ConstraintDescriptorImpl<B> descriptor, Type validatedValueType) {
        super(constraintValidatorManager, descriptor, validatedValueType);
    }

    @Override
    protected void validateConstraints(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, Collection<ConstraintValidatorContextImpl> violatedConstraintValidatorContexts) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Validating value %s against constraint defined by %s.", valueContext.getCurrentValidatedValue(), (Object)this.descriptor);
        }
        ConstraintValidator validator = this.getInitializedConstraintValidator(validationContext, valueContext);
        ConstraintValidatorContextImpl constraintValidatorContext = validationContext.createConstraintValidatorContextFor(this.descriptor, valueContext.getPropertyPath());
        if (this.validateSingleConstraint(valueContext, constraintValidatorContext, validator).isPresent()) {
            violatedConstraintValidatorContexts.add(constraintValidatorContext);
        }
    }
}

