/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.constraintvalidators.hv.pl;

import java.util.Collections;
import java.util.List;
import shadow.javax.validation.ConstraintValidator;
import shadow.org.hibernate.validator.constraints.pl.PESEL;
import shadow.org.hibernate.validator.internal.constraintvalidators.hv.ModCheckBase;
import shadow.org.hibernate.validator.internal.util.ModUtil;

public class PESELValidator
extends ModCheckBase
implements ConstraintValidator<PESEL, CharSequence> {
    private static final int[] WEIGHTS_PESEL = new int[]{1, 3, 7, 9, 1, 3, 7, 9, 1, 3};

    @Override
    public void initialize(PESEL constraintAnnotation) {
        super.initialize(0, Integer.MAX_VALUE, -1, false);
    }

    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        Collections.reverse(digits);
        if (digits.size() != WEIGHTS_PESEL.length) {
            return false;
        }
        int modResult = ModUtil.calculateModXCheckWithWeights(digits, 10, Integer.MAX_VALUE, WEIGHTS_PESEL);
        switch (modResult) {
            case 10: {
                return checkDigit == '0';
            }
        }
        return Character.isDigit(checkDigit) && modResult == this.extractDigit(checkDigit);
    }
}

