/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.constraintvalidators.hv;

import shadow.javax.validation.ConstraintValidatorContext;
import shadow.javax.validation.metadata.ConstraintDescriptor;
import shadow.org.hibernate.validator.constraints.ScriptAssert;
import shadow.org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import shadow.org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import shadow.org.hibernate.validator.internal.constraintvalidators.hv.AbstractScriptAssertValidator;
import shadow.org.hibernate.validator.internal.util.Contracts;
import shadow.org.hibernate.validator.internal.util.logging.Messages;

public class ScriptAssertValidator
extends AbstractScriptAssertValidator<ScriptAssert, Object> {
    private String alias;
    private String reportOn;
    private String message;

    @Override
    public void initialize(ConstraintDescriptor<ScriptAssert> constraintDescriptor, HibernateConstraintValidatorInitializationContext initializationContext) {
        ScriptAssert constraintAnnotation = constraintDescriptor.getAnnotation();
        this.validateParameters(constraintAnnotation);
        this.initialize(constraintAnnotation.lang(), constraintAnnotation.script(), initializationContext);
        this.alias = constraintAnnotation.alias();
        this.reportOn = constraintAnnotation.reportOn();
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        boolean validationResult;
        if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
            constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class).addMessageParameter("script", this.escapedScript);
        }
        if (!(validationResult = this.scriptAssertContext.evaluateScriptAssertExpression(value, this.alias)) && !this.reportOn.isEmpty()) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(this.message).addPropertyNode(this.reportOn).addConstraintViolation();
        }
        return validationResult;
    }

    private void validateParameters(ScriptAssert constraintAnnotation) {
        Contracts.assertNotEmpty(constraintAnnotation.script(), Messages.MESSAGES.parameterMustNotBeEmpty("script"));
        Contracts.assertNotEmpty(constraintAnnotation.lang(), Messages.MESSAGES.parameterMustNotBeEmpty("lang"));
        Contracts.assertNotEmpty(constraintAnnotation.alias(), Messages.MESSAGES.parameterMustNotBeEmpty("alias"));
    }
}

