/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.math.BigDecimal;
import shadow.javax.money.MonetaryAmount;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;
import shadow.javax.validation.constraints.Max;

public class MaxValidatorForMonetaryAmount
implements ConstraintValidator<Max, MonetaryAmount> {
    private BigDecimal maxValue;

    @Override
    public void initialize(Max maxValue) {
        this.maxValue = BigDecimal.valueOf(maxValue.value());
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return ((BigDecimal)value.getNumber().numberValueExact(BigDecimal.class)).compareTo(this.maxValue) != 1;
    }
}

