/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import shadow.javax.money.MonetaryAmount;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;
import shadow.javax.validation.constraints.DecimalMin;
import shadow.org.hibernate.validator.internal.util.logging.Log;
import shadow.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMinValidatorForMonetaryAmount
implements ConstraintValidator<DecimalMin, MonetaryAmount> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private BigDecimal minValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMin minValue) {
        try {
            this.minValue = new BigDecimal(minValue.value());
        }
        catch (NumberFormatException nfe) {
            throw LOG.getInvalidBigDecimalFormatException(minValue.value(), nfe);
        }
        this.inclusive = minValue.inclusive();
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int comparisonResult = ((BigDecimal)value.getNumber().numberValueExact(BigDecimal.class)).compareTo(this.minValue);
        return this.inclusive ? comparisonResult >= 0 : comparisonResult > 0;
    }
}

