/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import shadow.javax.money.MonetaryAmount;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;
import shadow.javax.validation.constraints.DecimalMax;
import shadow.org.hibernate.validator.internal.util.logging.Log;
import shadow.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMaxValidatorForMonetaryAmount
implements ConstraintValidator<DecimalMax, MonetaryAmount> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private BigDecimal maxValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw LOG.getInvalidBigDecimalFormatException(maxValue.value(), nfe);
        }
        this.inclusive = maxValue.inclusive();
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int comparisonResult = ((BigDecimal)value.getNumber().numberValueExact(BigDecimal.class)).compareTo(this.maxValue);
        return this.inclusive ? comparisonResult <= 0 : comparisonResult < 0;
    }
}

