/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.servlet.internal;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import shadow.javax.servlet.ServletContext;
import shadow.org.glassfish.jersey.server.ResourceConfig;

public final class Utils {
    private static final String RESOURCE_CONFIG = "jersey.config.servlet.internal.resourceConfig";

    public static void store(ResourceConfig config, ServletContext context, String configName) {
        String attributeName = "jersey.config.servlet.internal.resourceConfig_" + configName;
        context.setAttribute(attributeName, config);
    }

    public static ResourceConfig retrieve(ServletContext context, String configName) {
        String attributeName = "jersey.config.servlet.internal.resourceConfig_" + configName;
        ResourceConfig config = (ResourceConfig)context.getAttribute(attributeName);
        context.removeAttribute(attributeName);
        return config;
    }

    public static Map<String, Object> getContextParams(ServletContext servletContext) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration<String> names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            props.put(name, servletContext.getAttribute(name));
        }
        return props;
    }

    private Utils() {
    }
}

